/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

@Internal
public final class PercentageArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final boolean expectedNullability;

    public PercentageArgumentTypeStrategy(boolean nullable) {
        this.expectedNullability = nullable;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        LogicalType actualType = callContext.getArgumentDataTypes().get(argumentPos).getLogicalType();
        if (!actualType.is(LogicalTypeFamily.NUMERIC)) {
            return callContext.fail(throwOnFailure, "Percentage must be of NUMERIC type.", new Object[0]);
        }
        if (!this.expectedNullability && actualType.isNullable()) {
            return callContext.fail(throwOnFailure, "Percentage must be of NOT NULL type.", new Object[0]);
        }
        if (callContext.isArgumentLiteral(argumentPos)) {
            Optional<Number> literalVal = callContext.getArgumentValue(argumentPos, Number.class);
            Double val = null;
            if (literalVal.isPresent()) {
                val = literalVal.get().doubleValue();
            }
            if (val == null || val < 0.0 || val > 1.0) {
                return callContext.fail(throwOnFailure, "Percentage must be between [0.0, 1.0], but was '%s'.", val);
            }
        }
        return Optional.of(this.expectedNullability ? DataTypes.DOUBLE() : (DataType)DataTypes.DOUBLE().notNull());
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of(this.expectedNullability ? "<NUMERIC>" : "<NUMERIC NOT NULL>");
    }
}

