/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;

@Internal
public abstract class ThreadLocalCache<K, V> {
    private static final int DEFAULT_CACHE_SIZE = 64;
    private final ThreadLocal<BoundedMap<K, V>> cache = new ThreadLocal();
    private final int maxSizePerThread;

    protected ThreadLocalCache() {
        this(64);
    }

    protected ThreadLocalCache(int maxSizePerThread) {
        this.maxSizePerThread = maxSizePerThread;
    }

    public V get(K key) {
        Object value;
        BoundedMap map = this.cache.get();
        if (map == null) {
            map = new BoundedMap(this.maxSizePerThread);
            this.cache.set(map);
        }
        if ((value = map.get(key)) == null) {
            value = this.getNewInstance(key);
            map.put(key, value);
        }
        return value;
    }

    public abstract V getNewInstance(K var1);

    public static <K, V> ThreadLocalCache<K, V> of(final Function<K, V> creator) {
        return new ThreadLocalCache<K, V>(){

            @Override
            public V getNewInstance(K key) {
                return creator.apply(key);
            }
        };
    }

    private static class BoundedMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -211630219014422361L;
        private final int maxSize;

        private BoundedMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

