/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.NamedXAResource;

public class LocalXAResource
implements NamedXAResource {
    final LocalTransaction localTransaction;
    private final String name;
    private Xid xid;
    private int transactionTimeout;

    public LocalXAResource(LocalTransaction localTransaction, String name) {
        this.localTransaction = localTransaction;
        this.name = name;
    }

    public void commit(Xid xid, boolean flag) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw new XAException("Invalid Xid");
        }
        try {
            this.localTransaction.commit();
        }
        catch (ResourceException e) {
            throw (XAException)new XAException().initCause(e);
        }
        finally {
            this.xid = null;
        }
    }

    public void forget(Xid xid) throws XAException {
        this.xid = null;
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this == xares;
    }

    public Xid[] recover(int n) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw new XAException("Invalid Xid");
        }
        try {
            this.localTransaction.rollback();
        }
        catch (ResourceException e) {
            throw (XAException)new XAException().initCause(e);
        }
        finally {
            this.xid = null;
        }
    }

    public boolean setTransactionTimeout(int txTimeout) throws XAException {
        this.transactionTimeout = txTimeout;
        return true;
    }

    public void start(Xid xid, int flag) throws XAException {
        if (flag == 0) {
            if (this.xid != null) {
                throw new XAException("already enlisted");
            }
            this.xid = xid;
            try {
                this.localTransaction.begin();
            }
            catch (ResourceException e) {
                throw (XAException)new XAException("could not start local tx").initCause(e);
            }
        } else if (flag == 0x8000000) {
            if (xid != this.xid) {
                throw new XAException("attempting to resume in different transaction");
            }
        } else {
            throw new XAException("unknown state");
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        if (xid != this.xid) {
            throw new XAException("Invalid Xid");
        }
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public String getName() {
        return this.name;
    }
}

