/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNioProcessor
extends AbstractAjpProcessor<NioChannel> {
    private static final Log log = LogFactory.getLog(AjpNioProcessor.class);
    protected NioChannel socket;
    protected NioSelectorPool pool;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpNioProcessor(int packetSize, NioEndpoint endpoint) {
        super(packetSize, endpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.pool = endpoint.getSelectorPool();
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<NioChannel> socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socket = socket.getSocket();
        long soTimeout = this.endpoint.getSoTimeout();
        boolean cping = false;
        this.error = false;
        while (!this.error && !this.endpoint.isPaused()) {
            try {
                byte type;
                int bytesRead = this.readMessage(this.requestHeaderMessage, false);
                if (bytesRead == 0) break;
                if (this.keepAliveTimeout > 0) {
                    socket.setTimeout(soTimeout);
                }
                if ((type = this.requestHeaderMessage.getByte()) == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle(true);
                        break;
                    }
                    cping = true;
                    try {
                        this.output(pongMessageArray, 0, pongMessageArray.length);
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                    this.recycle(false);
                    continue;
                }
                if (type != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unexpected message: " + type));
                    }
                    this.error = true;
                    this.recycle(true);
                    break;
                }
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                log.debug((Object)sm.getString("ajpprocessor.header.error"), t);
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.debug((Object)sm.getString("ajpprocessor.request.prepare"), t);
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (!this.error && !cping && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            cping = false;
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)sm.getString("ajpprocessor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (this.isAsync() && !this.error) break;
            if (!this.finished) {
                try {
                    this.finish();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.error = true;
                }
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            if (this.keepAliveTimeout > 0) {
                socket.setTimeout(this.keepAliveTimeout);
            }
            this.recycle(false);
        }
        rp.setStage(7);
        if (!this.error && !this.endpoint.isPaused()) {
            if (this.isAsync()) {
                return AbstractEndpoint.Handler.SocketState.LONG;
            }
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                ((NioEndpoint)this.endpoint).processSocket(this.socket, SocketStatus.OPEN, false);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            long timeout = (Long)param;
            NioEndpoint.KeyAttachment ka = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
            if (this.keepAliveTimeout > 0) {
                ka.setTimeout(timeout);
            }
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            ((NioEndpoint)this.endpoint).processSocket(this.socket, SocketStatus.OPEN, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void output(byte[] src, int offset, int length) throws IOException {
        ByteBuffer writeBuffer = this.socket.getBufHandler().getWriteBuffer();
        writeBuffer.put(src, offset, length);
        writeBuffer.flip();
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException x) {
            // empty catch block
        }
        try {
            this.pool.write(writeBuffer, this.socket, selector, writeTimeout, true);
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        writeBuffer.clear();
    }

    protected int read(byte[] buf, int pos, int n, boolean blockFirstRead) throws IOException {
        int read;
        int res = 0;
        boolean block = blockFirstRead;
        for (read = 0; read < n; read += res) {
            res = this.readSocket(buf, read + pos, n, block);
            if (res > 0) {
            } else {
                if (res == 0 && !block) break;
                throw new IOException(sm.getString("ajpprocessor.failedread"));
            }
            block = true;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(byte[] buf, int pos, int n, boolean block) throws IOException {
        int nRead = 0;
        this.socket.getBufHandler().getReadBuffer().clear();
        this.socket.getBufHandler().getReadBuffer().limit(n);
        if (block) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
                if (att == null) {
                    throw new IOException("Key must be cancelled.");
                }
                nRead = this.pool.read(this.socket.getBufHandler().getReadBuffer(), this.socket, selector, att.getTimeout());
            }
            catch (EOFException eof) {
                nRead = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            nRead = this.socket.read(this.socket.getBufHandler().getReadBuffer());
        }
        if (nRead > 0) {
            this.socket.getBufHandler().getReadBuffer().flip();
            this.socket.getBufHandler().getReadBuffer().limit(nRead);
            this.socket.getBufHandler().getReadBuffer().get(buf, pos, nRead);
            return nRead;
        }
        if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return 0;
    }

    @Override
    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        this.readMessage(this.bodyMessage, true);
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMessage.peekInt();
        if (blen == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    protected int readMessage(AjpMessage message, boolean blockFirstRead) throws IOException {
        int headerLength;
        byte[] buf = message.getBuffer();
        int bytesRead = this.read(buf, 0, headerLength = message.getHeaderLength(), blockFirstRead);
        if (bytesRead == 0) {
            return 0;
        }
        int messageLength = message.processHeader(true);
        if (messageLength < 0) {
            throw new IOException(sm.getString("ajpmessage.invalidLength", new Object[]{messageLength}));
        }
        if (messageLength == 0) {
            return bytesRead;
        }
        if (messageLength > buf.length) {
            throw new IllegalArgumentException(sm.getString("ajpprocessor.header.tooLong", new Object[]{messageLength, buf.length}));
        }
        return bytesRead += this.read(buf, headerLength, messageLength, true);
    }
}

