/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.LimitLatch;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public abstract class AbstractEndpoint {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.net.res");
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = false;
    private volatile LimitLatch connectionLimitLatch = null;
    protected SocketProperties socketProperties = new SocketProperties();
    protected Acceptor[] acceptors;
    protected int acceptorThreadCount = 0;
    protected int acceptorThreadPriority = 5;
    private int maxConnections = 10000;
    private Executor executor = null;
    private int port;
    private InetAddress address;
    private int backlog = 100;
    private boolean bindOnInit = true;
    private BindState bindState = BindState.UNBOUND;
    private Integer keepAliveTimeout = null;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    private int maxKeepAliveRequests = 100;
    private int maxHeaderCount = 100;
    private String name = "TP";
    private boolean daemon = true;
    protected int threadPriority = 5;
    protected HashMap<String, Object> attributes = new HashMap();
    private String algorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String clientAuth = "false";
    private String keystoreFile = System.getProperty("user.home") + "/.keystore";
    private String keystorePass = null;
    private String keystoreType = "JKS";
    private String keystoreProvider = null;
    private String sslProtocol = "TLS";
    private String ciphers = null;
    private String[] ciphersarr = new String[0];
    private String keyAlias = null;
    private String keyPass = null;
    private String truststoreFile = System.getProperty("javax.net.ssl.trustStore");
    private String truststorePass = System.getProperty("javax.net.ssl.trustStorePassword");
    private String truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
    private String truststoreProvider = null;
    private String truststoreAlgorithm = null;
    private String trustManagerClassName = null;
    private String crlFile = null;
    private String trustMaxCertLength = null;
    private String sessionCacheSize = null;
    private String sessionTimeout = "86400";
    private String allowUnsafeLegacyRenegotiation = null;
    private String[] sslEnabledProtocolsarr = new String[0];

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setAcceptorThreadPriority(int acceptorThreadPriority) {
        this.acceptorThreadPriority = acceptorThreadPriority;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setMaxConnections(int maxCon) {
        this.maxConnections = maxCon;
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            if (maxCon == -1) {
                this.releaseConnectionLatch();
            } else {
                latch.setLimit((long)maxCon);
            }
        } else if (maxCon > 0) {
            this.initializeConnectionLatch();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionCount() {
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            return latch.getCount();
        }
        return -1L;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public abstract int getLocalPort();

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean b) {
        this.bindOnInit = b;
    }

    public int getKeepAliveTimeout() {
        if (this.keepAliveTimeout == null) {
            return this.getSoTimeout();
        }
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.socketProperties.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setSoLinger(int soLinger) {
        this.socketProperties.setSoLingerTime(soLinger);
        this.socketProperties.setSoLingerOn(soLinger >= 0);
    }

    public int getSoTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.socketProperties.setSoTimeout(soTimeout);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public int getMinSpareThreads() {
        return Math.min(this.minSpareThreads, this.getMaxThreads());
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        if (this.running && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                ((java.util.concurrent.ThreadPoolExecutor)this.executor).setCorePoolSize(minSpareThreads);
            } else if (this.executor instanceof ResizableExecutor) {
                ((ResizableExecutor)this.executor).resizePool(minSpareThreads, this.maxThreads);
            }
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.running && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                ((java.util.concurrent.ThreadPoolExecutor)this.executor).setMaximumPoolSize(maxThreads);
            } else if (this.executor instanceof ResizableExecutor) {
                ((ResizableExecutor)this.executor).resizePool(this.minSpareThreads, maxThreads);
            }
        }
    }

    public int getMaxThreads() {
        return this.getMaxThreadsExecutor(this.running);
    }

    protected int getMaxThreadsExecutor(boolean useExecutor) {
        if (useExecutor && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                return ((java.util.concurrent.ThreadPoolExecutor)this.executor).getMaximumPoolSize();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getMaxThreads();
            }
            return -1;
        }
        return this.maxThreads;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    protected abstract boolean getDeferAccept();

    public void setAttribute(String name, Object value) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("abstractProtocolHandler.setAttribute", new Object[]{name, value}));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        Object value = this.attributes.get(key);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("abstractProtocolHandler.getAttribute", new Object[]{key, value}));
        }
        return value;
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        String socketName = "socket.";
        try {
            if (name.startsWith("socket.")) {
                return IntrospectionUtils.setProperty((Object)this.socketProperties, (String)name.substring("socket.".length()), (String)value);
            }
            return IntrospectionUtils.setProperty((Object)this, (String)name, (String)value, (boolean)false);
        }
        catch (Exception x) {
            this.getLog().error((Object)("Unable to set attribute \"" + name + "\" to \"" + value + "\""), (Throwable)x);
            return false;
        }
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public int getCurrentThreadCount() {
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getPoolSize();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getActiveCount();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        TaskQueue taskqueue = new TaskQueue();
        TaskThreadFactory tf = new TaskThreadFactory(this.getName() + "-exec-", this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue)taskqueue, (ThreadFactory)tf);
        taskqueue.setParent((ThreadPoolExecutor)this.executor);
    }

    public void shutdownExecutor() {
        if (this.executor != null && this.internalExecutor) {
            if (this.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
                tpe.shutdownNow();
                TaskQueue queue = (TaskQueue)tpe.getQueue();
                queue.setParent(null);
            }
            this.executor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        boolean unlockRequired = false;
        for (Acceptor acceptor : this.acceptors) {
            if (acceptor.getState() != Acceptor.AcceptorState.RUNNING) continue;
            unlockRequired = true;
            break;
        }
        if (!unlockRequired) {
            return;
        }
        Socket s = null;
        InetSocketAddress saddr = null;
        try {
            saddr = this.address == null ? new InetSocketAddress("localhost", this.getLocalPort()) : new InetSocketAddress(this.address, this.getLocalPort());
            s = new Socket();
            int stmo = 2000;
            int utmo = 2000;
            if (this.getSocketProperties().getSoTimeout() > stmo) {
                stmo = this.getSocketProperties().getSoTimeout();
            }
            if (this.getSocketProperties().getUnlockTimeout() > utmo) {
                utmo = this.getSocketProperties().getUnlockTimeout();
            }
            s.setSoTimeout(stmo);
            s.setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("About to unlock socket for:" + saddr));
            }
            s.connect(saddr, utmo);
            if (this.getDeferAccept()) {
                OutputStreamWriter sw = new OutputStreamWriter(s.getOutputStream(), "ISO-8859-1");
                sw.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
                sw.flush();
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Socket unlock completed for:" + saddr));
            }
            long waitLeft = 1000L;
            for (Acceptor acceptor : this.acceptors) {
                while (waitLeft > 0L && acceptor.getState() == Acceptor.AcceptorState.RUNNING) {
                    Thread.sleep(50L);
                    waitLeft -= 50L;
                }
            }
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock", new Object[]{"" + this.getPort()}), (Throwable)e);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    public final void init() throws Exception {
        if (this.bindOnInit) {
            this.bind();
            this.bindState = BindState.BOUND_ON_INIT;
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.bind();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    protected final void startAcceptorThreads() {
        int count = this.getAcceptorThreadCount();
        this.acceptors = new Acceptor[count];
        for (int i = 0; i < count; ++i) {
            this.acceptors[i] = this.createAcceptor();
            String threadName = this.getName() + "-Acceptor-" + i;
            this.acceptors[i].setThreadName(threadName);
            Thread t = new Thread((Runnable)this.acceptors[i], threadName);
            t.setPriority(this.getAcceptorThreadPriority());
            t.setDaemon(this.getDaemon());
            t.start();
        }
    }

    protected abstract Acceptor createAcceptor();

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public String adjustRelativePath(String path, String relativeTo) {
        String newPath = path;
        File f = new File(newPath);
        if (!f.isAbsolute()) {
            newPath = relativeTo + File.separator + newPath;
            f = new File(newPath);
        }
        if (!f.exists()) {
            this.getLog().warn((Object)("configured file:[" + newPath + "] does not exist."));
        }
        return newPath;
    }

    protected abstract Log getLog();

    public abstract boolean getUseSendfile();

    public abstract boolean getUseComet();

    public abstract boolean getUseCometTimeout();

    public abstract boolean getUsePolling();

    protected LimitLatch initializeConnectionLatch() {
        if (this.maxConnections == -1) {
            return null;
        }
        if (this.connectionLimitLatch == null) {
            this.connectionLimitLatch = new LimitLatch((long)this.getMaxConnections());
        }
        return this.connectionLimitLatch;
    }

    protected void releaseConnectionLatch() {
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            latch.releaseAll();
        }
        this.connectionLimitLatch = null;
    }

    protected void countUpOrAwaitConnection() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            latch.countUpOrAwait();
        }
    }

    protected long countDownConnection() {
        if (this.maxConnections == -1) {
            return -1L;
        }
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            long result = latch.countDown();
            if (result < 0L) {
                this.getLog().warn((Object)"Incorrect connection count, multiple socket.close called on the same socket.");
            }
            return result;
        }
        return -1L;
    }

    protected int handleExceptionWithDelay(int currentErrorDelay) {
        if (currentErrorDelay > 0) {
            try {
                Thread.sleep(currentErrorDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (currentErrorDelay == 0) {
            return 50;
        }
        if (currentErrorDelay < 1600) {
            return currentErrorDelay * 2;
        }
        return 1600;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String s) {
        this.algorithm = s;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String s) {
        this.clientAuth = s;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String s) {
        String file;
        this.keystoreFile = file = this.adjustRelativePath(s, System.getProperty("catalina.base"));
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String s) {
        this.keystorePass = s;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String s) {
        this.keystoreType = s;
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public void setKeystoreProvider(String s) {
        this.keystoreProvider = s;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String s) {
        this.sslProtocol = s;
    }

    public String[] getCiphersArray() {
        return this.ciphersarr;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String s) {
        this.ciphers = s;
        if (s == null) {
            this.ciphersarr = new String[0];
        } else {
            StringTokenizer t = new StringTokenizer(s, ",");
            this.ciphersarr = new String[t.countTokens()];
            for (int i = 0; i < this.ciphersarr.length; ++i) {
                this.ciphersarr[i] = t.nextToken();
            }
        }
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String s) {
        this.keyAlias = s;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String s) {
        this.keyPass = s;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststoreFile(String s) {
        String file;
        this.truststoreFile = s == null ? null : (file = this.adjustRelativePath(s, System.getProperty("catalina.base")));
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getTruststoreProvider() {
        return this.truststoreProvider;
    }

    public void setTruststoreProvider(String truststoreProvider) {
        this.truststoreProvider = truststoreProvider;
    }

    public String getTruststoreAlgorithm() {
        return this.truststoreAlgorithm;
    }

    public void setTruststoreAlgorithm(String truststoreAlgorithm) {
        this.truststoreAlgorithm = truststoreAlgorithm;
    }

    public String getTrustManagerClassName() {
        return this.trustManagerClassName;
    }

    public void setTrustManagerClassName(String trustManagerClassName) {
        this.trustManagerClassName = trustManagerClassName;
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String trustMaxCertLength) {
        this.trustMaxCertLength = trustMaxCertLength;
    }

    public String getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setSessionCacheSize(String s) {
        this.sessionCacheSize = s;
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String s) {
        this.sessionTimeout = s;
    }

    public String getAllowUnsafeLegacyRenegotiation() {
        return this.allowUnsafeLegacyRenegotiation;
    }

    public void setAllowUnsafeLegacyRenegotiation(String s) {
        this.allowUnsafeLegacyRenegotiation = s;
    }

    public String[] getSslEnabledProtocolsArray() {
        return this.sslEnabledProtocolsarr;
    }

    public void setSslEnabledProtocols(String s) {
        if (s == null) {
            this.sslEnabledProtocolsarr = new String[0];
        } else {
            ArrayList<String> sslEnabledProtocols = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(s, ",");
            while (t.hasMoreTokens()) {
                String p = t.nextToken().trim();
                if (p.length() <= 0) continue;
                sslEnabledProtocols.add(p);
            }
            this.sslEnabledProtocolsarr = sslEnabledProtocols.toArray(new String[sslEnabledProtocols.size()]);
        }
    }

    public static abstract class Acceptor
    implements Runnable {
        protected volatile AcceptorState state = AcceptorState.NEW;
        private String threadName;

        public final AcceptorState getState() {
            return this.state;
        }

        protected final void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        protected final String getThreadName() {
            return this.threadName;
        }

        public static enum AcceptorState {
            NEW,
            RUNNING,
            PAUSED,
            ENDED;

        }
    }

    protected static enum BindState {
        UNBOUND,
        BOUND_ON_INIT,
        BOUND_ON_START;

    }

    public static interface Handler {
        public Object getGlobal();

        public void recycle();

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END,
            SENDFILE,
            UPGRADING,
            UPGRADED;

        }
    }
}

