/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli;

import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.geronimo.cli.CLParser;
import org.apache.geronimo.cli.CLParserException;

public class BaseCLParser
implements CLParser {
    private static final String ARGUMENT_HELP_SHORTFORM = "h";
    private static final String ARGUMENT_HELP = "help";
    private static final String ARGUMENT_VERBOSE_INFO_SHORTFORM = "v";
    private static final String ARGUMENT_VERBOSE_INFO = "verbose";
    private static final String ARGUMENT_VERBOSE_DEBUG_SHORTFORM = "vv";
    private static final String ARGUMENT_VERBOSE_DEBUG = "veryverbose";
    private static final String ARGUMENT_VERBOSE_TRACE_SHORTFORM = "vvv";
    private static final String ARGUMENT_VERBOSE_TRACE = "veryveryverbose";
    protected final OutputStream out;
    protected final Options options;
    protected CommandLine commandLine;

    public BaseCLParser(OutputStream out) {
        if (null == out) {
            throw new IllegalArgumentException("out is required");
        }
        this.out = out;
        this.options = new Options();
        this.addVerboseOptions();
        this.addHelp();
    }

    public void parse(String[] args) throws CLParserException {
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(this.options, args, true);
        }
        catch (ParseException e) {
            throw new CLParserException(e);
        }
        this.validateOptions();
        this.validateRemainingArgs();
    }

    public boolean isHelp() {
        return this.commandLine.hasOption(ARGUMENT_HELP_SHORTFORM);
    }

    public boolean isVerboseInfo() {
        return this.commandLine.hasOption(ARGUMENT_VERBOSE_INFO_SHORTFORM);
    }

    public boolean isVerboseDebug() {
        return this.commandLine.hasOption(ARGUMENT_VERBOSE_DEBUG_SHORTFORM);
    }

    public boolean isVerboseTrace() {
        return this.commandLine.hasOption(ARGUMENT_VERBOSE_TRACE_SHORTFORM);
    }

    public String[] getArgs() {
        return this.commandLine.getArgs();
    }

    public void displayHelp() {
        throw new UnsupportedOperationException();
    }

    protected void displayHelp(String[] args) {
        throw new UnsupportedOperationException();
    }

    protected void validateOptions() throws CLParserException {
    }

    protected void validateRemainingArgs() throws CLParserException {
    }

    protected void addHelp() {
        this.options.addOption(ARGUMENT_HELP_SHORTFORM, ARGUMENT_HELP, false, "Display this help.");
    }

    protected void addVerboseOptions() {
        OptionGroup optionGroup = new OptionGroup();
        Option option = new Option(ARGUMENT_VERBOSE_INFO_SHORTFORM, ARGUMENT_VERBOSE_INFO, false, "Reduces the console log level to INFO, resulting in more console output than is normally present.");
        optionGroup.addOption(option);
        option = new Option(ARGUMENT_VERBOSE_DEBUG_SHORTFORM, ARGUMENT_VERBOSE_DEBUG, false, "Reduces the console log level to DEBUG, resulting in still more console output.");
        optionGroup.addOption(option);
        option = new Option(ARGUMENT_VERBOSE_TRACE_SHORTFORM, ARGUMENT_VERBOSE_TRACE, false, "Reduces the console log level to TRACE, resulting in still more console output.");
        optionGroup.addOption(option);
        this.options.addOptionGroup(optionGroup);
    }
}

