/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli;

import java.io.PrintStream;
import org.apache.geronimo.cli.CLParser;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.main.Bootstrapper;

public abstract class AbstractCLI {
    private final String[] args;
    private final PrintStream errStream;

    protected AbstractCLI(String[] args, PrintStream errStream) {
        if (null == args) {
            throw new IllegalArgumentException("args is required");
        }
        if (null == errStream) {
            throw new IllegalArgumentException("errStream is required");
        }
        this.args = args;
        this.errStream = errStream;
    }

    public int executeMain() {
        CLParser parser = this.getCLParser();
        try {
            parser.parse(this.args);
        }
        catch (CLParserException e) {
            this.errStream.println(e.getMessage());
            parser.displayHelp();
            return 1;
        }
        if (parser.isHelp()) {
            parser.displayHelp();
            return 0;
        }
        boolean executed = this.executeCommand(parser);
        if (executed) {
            return 0;
        }
        this.initializeLogging(parser);
        Bootstrapper boot = this.createBootstrapper(parser);
        return boot.execute((Object)parser);
    }

    protected Bootstrapper createBootstrapper(CLParser parser) {
        return new Bootstrapper();
    }

    protected boolean executeCommand(CLParser parser) {
        return false;
    }

    protected void initializeLogging(CLParser parser) {
        assert (parser != null);
        String level = "WARN";
        if (parser.isVerboseInfo()) {
            level = "INFO";
        } else if (parser.isVerboseDebug()) {
            level = "DEBUG";
        } else if (parser.isVerboseTrace()) {
            level = "TRACE";
        }
        System.setProperty("org.apache.geronimo.log.ConsoleLogLevel", level);
    }

    protected abstract CLParser getCLParser();
}

