/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli.daemon;

import java.io.OutputStream;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.geronimo.cli.BaseCLParser;
import org.apache.geronimo.cli.PrintHelper;

public class DaemonCLParser
extends BaseCLParser {
    private static final String ARGUMENT_NO_PROGRESS_SHORTFORM = "q";
    private static final String ARGUMENT_NO_PROGRESS = "quiet";
    private static final String ARGUMENT_LONG_PROGRESS_SHORTFORM = "l";
    private static final String ARGUMENT_LONG_PROGRESS = "long";
    private static final String ARGUMENT_MODULE_OVERRIDE_SHORTFORM = "o";
    private static final String ARGUMENT_MODULE_OVERRIDE = "override";
    private static final String ARGUMENT_SECURE_SHORTFORM = "s";
    private static final String ARGUMENT_SECURE = "secure";
    private static final String ARGUMENT_CLEAN_CACHE_SHORTFORM = "c";
    private static final String ARGUMENT_CLEAN_CACHE = "clean";

    public DaemonCLParser(OutputStream out) {
        super(out);
        this.addProgressOptions();
        this.addOverride();
        this.addSecure();
        this.addCleanCache();
    }

    public boolean isCleanCache() {
        return this.commandLine.hasOption(ARGUMENT_CLEAN_CACHE_SHORTFORM);
    }

    public boolean isSecure() {
        return this.commandLine.hasOption(ARGUMENT_SECURE_SHORTFORM);
    }

    public boolean isNoProgress() {
        return this.commandLine.hasOption(ARGUMENT_NO_PROGRESS_SHORTFORM);
    }

    public boolean isLongProgress() {
        return this.commandLine.hasOption(ARGUMENT_LONG_PROGRESS_SHORTFORM);
    }

    public String[] getOverride() {
        return this.commandLine.getOptionValues(ARGUMENT_MODULE_OVERRIDE_SHORTFORM);
    }

    @Override
    public void displayHelp() {
        PrintHelper printHelper = new PrintHelper(this.out);
        printHelper.printHelp("java -jar bin/server.jar $options", "\nThe following options are available:", this.options, "\nIn addition you may specify a replacement for var/config/config.xml by setting the property -Dorg.apache.geronimo.config.file=var/config/<my-config.xml>. This is resolved relative to the geronimo base directory.\n", true);
    }

    protected void addOverride() {
        OptionBuilder.hasArgs();
        OptionBuilder optionBuilder = OptionBuilder.withArgName((String)"moduleId ...");
        optionBuilder = OptionBuilder.withLongOpt((String)ARGUMENT_MODULE_OVERRIDE);
        optionBuilder = OptionBuilder.withDescription((String)"USE WITH CAUTION!  Overrides the modules in var/config/config.xml such that only the modules listed on the command line will be started.  Note that many J2EE features depend on certain modules being started, so you should be very careful what you omit.  Any arguments after this are assumed to be module names.");
        Option option = OptionBuilder.create((String)ARGUMENT_MODULE_OVERRIDE_SHORTFORM);
        this.options.addOption(option);
    }

    protected void addSecure() {
        this.options.addOption(ARGUMENT_SECURE_SHORTFORM, ARGUMENT_SECURE, false, "Use secure channel to communicate with the server.  Unsecured channel is used by default.");
    }

    protected void addCleanCache() {
        this.options.addOption(ARGUMENT_CLEAN_CACHE_SHORTFORM, ARGUMENT_CLEAN_CACHE, false, "Delete cache folder. This is typically used when developer wants to pick up artifacts modification in repository");
    }

    protected void addProgressOptions() {
        OptionGroup optionGroup = new OptionGroup();
        Option option = new Option(ARGUMENT_NO_PROGRESS_SHORTFORM, ARGUMENT_NO_PROGRESS, false, "Suppress the normal startup progress bar. This is typically used when redirecting console output to a file, or starting the server from an IDE or other tool.");
        optionGroup.addOption(option);
        option = new Option(ARGUMENT_LONG_PROGRESS_SHORTFORM, ARGUMENT_LONG_PROGRESS, false, "Write startup progress to the console in a format that is suitable for redirecting console output to a file, or starting the server from an IDE or other tool (doesn't use linefeeds to update the progress information that is used by default if you don't specify quiet or long).");
        optionGroup.addOption(option);
        this.options.addOptionGroup(optionGroup);
    }
}

