/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli.deployer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.deployer.InstallBundleCommandArgs;

public class InstallBundleCommandArgsImpl
implements InstallBundleCommandArgs {
    private static final String ARGUMENT_GROUP_ID_SHORTFORM = "g";
    private static final String ARGUMENT_GROUP_ID = "groupId";
    private static final String ARGUMENT_START_SHORTFORM = "s";
    private static final String ARGUMENT_START = "start";
    private static final String ARGUMENT_START_LEVEL_SHORTFORM = "l";
    private static final String ARGUMENT_START_LEVEL = "startLevel";
    protected final Options options = new Options();
    protected CommandLine commandLine;

    public InstallBundleCommandArgsImpl(String[] args) throws CLParserException {
        this.addGroupId();
        this.addStart();
        this.addStartLevel();
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(this.options, args, true);
        }
        catch (ParseException e) {
            throw new CLParserException(e.getMessage(), e);
        }
        if (0 == this.commandLine.getArgs().length) {
            throw new CLParserException("Must specify a bundle file");
        }
    }

    protected void addStart() {
        this.options.addOption(ARGUMENT_START_SHORTFORM, ARGUMENT_START, false, "If start is provided, the bundle will be automatically started after recorded in Geronimo.");
    }

    protected void addStartLevel() {
        OptionBuilder.hasArg();
        OptionBuilder optionBuilder = OptionBuilder.withArgName((String)ARGUMENT_START_LEVEL);
        optionBuilder = OptionBuilder.withLongOpt((String)ARGUMENT_START_LEVEL);
        optionBuilder = OptionBuilder.withDescription((String)"If no start level are provided, will use the framework's initial bundle start level");
        Option option = OptionBuilder.create((String)ARGUMENT_START_LEVEL_SHORTFORM);
        this.options.addOption(option);
    }

    protected void addGroupId() {
        OptionBuilder.hasArg();
        OptionBuilder optionBuilder = OptionBuilder.withArgName((String)ARGUMENT_GROUP_ID);
        optionBuilder = OptionBuilder.withLongOpt((String)ARGUMENT_GROUP_ID);
        optionBuilder = OptionBuilder.withDescription((String)"If gourpId is not provided, will use \"default\" as its group id.");
        Option option = OptionBuilder.create((String)ARGUMENT_GROUP_ID_SHORTFORM);
        this.options.addOption(option);
    }

    @Override
    public boolean isStart() {
        return this.commandLine.hasOption(ARGUMENT_START_SHORTFORM);
    }

    @Override
    public int getStartLevel() {
        String startLevelStr = this.commandLine.getOptionValue(ARGUMENT_START_LEVEL_SHORTFORM);
        if (null == startLevelStr) {
            return -1;
        }
        return Integer.valueOf(startLevelStr);
    }

    @Override
    public String getGroupId() {
        String groupId = this.commandLine.getOptionValue(ARGUMENT_GROUP_ID_SHORTFORM);
        return groupId;
    }

    @Override
    public String[] getArgs() {
        return this.commandLine.getArgs();
    }
}

