/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto.asn1.x509;

import org.apache.geronimo.crypto.asn1.ASN1Encodable;
import org.apache.geronimo.crypto.asn1.ASN1EncodableVector;
import org.apache.geronimo.crypto.asn1.ASN1Sequence;
import org.apache.geronimo.crypto.asn1.ASN1TaggedObject;
import org.apache.geronimo.crypto.asn1.DERObject;
import org.apache.geronimo.crypto.asn1.DERSequence;
import org.apache.geronimo.crypto.asn1.x509.DistributionPoint;

public class CRLDistPoint
extends ASN1Encodable {
    ASN1Sequence seq = null;

    public static CRLDistPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CRLDistPoint getInstance(Object obj) {
        if (obj instanceof CRLDistPoint) {
            return (CRLDistPoint)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CRLDistPoint((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CRLDistPoint(ASN1Sequence seq) {
        this.seq = seq;
    }

    public CRLDistPoint(DistributionPoint[] points) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != points.length; ++i) {
            v.add(points[i]);
        }
        this.seq = new DERSequence(v);
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] dp = new DistributionPoint[this.seq.size()];
        for (int i = 0; i != this.seq.size(); ++i) {
            dp[i] = DistributionPoint.getInstance(this.seq.getObjectAt(i));
        }
        return dp;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

