/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geronimo.crypto.encoders.HexEncoder;

public class CertificateUtil {
    public static String generateFingerprint(Certificate cert, String digestAlgorithm) throws NoSuchAlgorithmException, CertificateEncodingException, IOException {
        MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
        byte[] digest = md.digest(cert.getEncoded());
        ByteArrayOutputStream out = new ByteArrayOutputStream(digest.length * 2);
        new HexEncoder().encode(digest, 0, digest.length, out);
        String all = new String(out.toByteArray(), "US-ASCII").toUpperCase();
        Matcher matcher = Pattern.compile("..").matcher(all);
        StringBuilder buf = new StringBuilder();
        while (matcher.find()) {
            if (buf.length() > 0) {
                buf.append(":");
            }
            buf.append(matcher.group());
        }
        return buf.toString();
    }
}

