/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.crypto.AbstractEncryption;

public class ConfiguredEncryption
extends AbstractEncryption {
    private static final Log log = LogFactory.getLog(ConfiguredEncryption.class);
    private SecretKeySpec spec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredEncryption(String location) throws IOException {
        File keyFile = new File(location);
        ObjectInputStream oin = null;
        if (keyFile != null) {
            if (keyFile.exists()) {
                FileInputStream fi = new FileInputStream(keyFile);
                try {
                    oin = new ObjectInputStream(fi);
                    this.spec = (SecretKeySpec)oin.readObject();
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Unable to read object or class not found: ", (Throwable)e);
                }
                finally {
                    if (oin != null) {
                        oin.close();
                    }
                    if (fi != null) {
                        fi.close();
                    }
                }
            } else {
                SecureRandom random = new SecureRandom();
                random.setSeed(System.currentTimeMillis());
                byte[] bytes = new byte[16];
                random.nextBytes(bytes);
                this.spec = new SecretKeySpec(bytes, "AES");
                File dir = keyFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    throw new IllegalStateException("Could not create directory for secret key spec: " + dir);
                }
                FileOutputStream out = new FileOutputStream(keyFile);
                try {
                    ObjectOutputStream oout = new ObjectOutputStream(out);
                    try {
                        oout.writeObject(this.spec);
                        oout.flush();
                    }
                    finally {
                        oout.close();
                    }
                }
                finally {
                    out.close();
                }
                log.info((Object)("Generate a new configured encryption password: " + this.spec.getEncoded().toString()));
            }
        }
    }

    @Override
    protected SecretKeySpec getSecretKeySpec() {
        return this.spec;
    }
}

