/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto.asn1.x509;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.geronimo.crypto.asn1.ASN1Encodable;
import org.apache.geronimo.crypto.asn1.ASN1EncodableVector;
import org.apache.geronimo.crypto.asn1.ASN1Sequence;
import org.apache.geronimo.crypto.asn1.DERInteger;
import org.apache.geronimo.crypto.asn1.DERObject;
import org.apache.geronimo.crypto.asn1.DERSequence;
import org.apache.geronimo.crypto.asn1.x509.DisplayText;

public class NoticeReference
extends ASN1Encodable {
    DisplayText organization;
    ASN1Sequence noticeNumbers;

    public NoticeReference(String orgName, Vector numbers) {
        this.organization = new DisplayText(orgName);
        Object o = numbers.elementAt(0);
        ASN1EncodableVector av = new ASN1EncodableVector();
        if (o instanceof Integer) {
            Enumeration it = numbers.elements();
            while (it.hasMoreElements()) {
                Integer nm = (Integer)it.nextElement();
                DERInteger di = new DERInteger(nm);
                av.add(di);
            }
        }
        this.noticeNumbers = new DERSequence(av);
    }

    public NoticeReference(String orgName, ASN1Sequence numbers) {
        this.organization = new DisplayText(orgName);
        this.noticeNumbers = numbers;
    }

    public NoticeReference(int displayTextType, String orgName, ASN1Sequence numbers) {
        this.organization = new DisplayText(displayTextType, orgName);
        this.noticeNumbers = numbers;
    }

    public NoticeReference(ASN1Sequence as) {
        this.organization = DisplayText.getInstance(as.getObjectAt(0));
        this.noticeNumbers = (ASN1Sequence)as.getObjectAt(1);
    }

    public static NoticeReference getInstance(Object as) {
        if (as instanceof NoticeReference) {
            return (NoticeReference)as;
        }
        if (as instanceof ASN1Sequence) {
            return new NoticeReference((ASN1Sequence)as);
        }
        throw new IllegalArgumentException("unknown object in getInstance.");
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector av = new ASN1EncodableVector();
        av.add(this.organization);
        av.add(this.noticeNumbers);
        return new DERSequence(av);
    }
}

