/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.lang.reflect.Method;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.annotation.EncryptionSetting;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.gbean.runtime.FastMethodInvoker;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.MethodInvoker;
import org.apache.geronimo.gbean.runtime.ReflectionMethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;

public class GBeanAttribute {
    private final GBeanInstance gbeanInstance;
    private final String name;
    private final Class type;
    private final boolean readable;
    private final MethodInvoker getInvoker;
    private final boolean writable;
    private final MethodInvoker setInvoker;
    private final boolean persistent;
    private final boolean manageable;
    private final EncryptionSetting encrypted;
    private Object persistentValue;
    private final boolean special;
    private final boolean framework;
    private final boolean dynamic;
    private final GAttributeInfo attributeInfo;

    static GBeanAttribute createSpecialAttribute(GBeanAttribute attribute, GBeanInstance gbeanInstance, String name, Class type, Object value) {
        return new GBeanAttribute(attribute, gbeanInstance, name, type, value);
    }

    private GBeanAttribute(GBeanAttribute attribute, GBeanInstance gbeanInstance, String name, Class type, Object value) {
        this.special = true;
        this.persistentValue = value;
        this.framework = false;
        this.dynamic = false;
        if (gbeanInstance == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (attribute != null) {
            assert (gbeanInstance == attribute.gbeanInstance);
            assert (name.equals(attribute.name));
            if (type != attribute.type) {
                throw new InvalidConfigurationException("Special attribute " + name + " must have the type " + type.getName() + ", but is " + attribute.type.getName() + ": targetClass=" + gbeanInstance.getType().getName());
            }
            if (attribute.isPersistent()) {
                throw new InvalidConfigurationException("Special attributes must not be persistent: name=" + name + ", targetClass=" + gbeanInstance.getType().getName());
            }
        }
        this.gbeanInstance = gbeanInstance;
        this.name = name;
        this.type = type;
        this.getInvoker = null;
        this.readable = true;
        this.setInvoker = attribute != null ? attribute.setInvoker : null;
        this.writable = false;
        this.persistent = false;
        this.manageable = false;
        this.encrypted = EncryptionSetting.PLAINTEXT;
        if (attribute != null) {
            GAttributeInfo attributeInfo = attribute.getAttributeInfo();
            this.attributeInfo = new GAttributeInfo(this.name, this.type.getName(), this.persistent, this.manageable, this.encrypted, this.readable, this.writable, attributeInfo.getGetterName(), attributeInfo.getSetterName());
        } else {
            this.attributeInfo = new GAttributeInfo(this.name, this.type.getName(), this.persistent, this.manageable, this.encrypted, this.readable, this.writable, null, null);
        }
    }

    static GBeanAttribute createFrameworkAttribute(GBeanInstance gbeanInstance, String name, Class type, MethodInvoker getInvoker) {
        return new GBeanAttribute(gbeanInstance, name, type, getInvoker, null, false, null, true);
    }

    static GBeanAttribute createFrameworkAttribute(GBeanInstance gbeanInstance, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker, boolean persistent, Object persistentValue, boolean manageable) {
        return new GBeanAttribute(gbeanInstance, name, type, getInvoker, setInvoker, persistent, persistentValue, manageable);
    }

    private GBeanAttribute(GBeanInstance gbeanInstance, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker, boolean persistent, Object persistentValue, boolean manageable) {
        this.special = false;
        this.framework = true;
        this.dynamic = false;
        if (gbeanInstance == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        this.gbeanInstance = gbeanInstance;
        this.name = name;
        this.type = type;
        this.getInvoker = getInvoker;
        this.readable = this.getInvoker != null;
        this.setInvoker = setInvoker;
        this.writable = this.setInvoker != null;
        this.persistent = persistent;
        this.manageable = manageable;
        this.attributeInfo = new GAttributeInfo(this.name, this.type.getName(), this.persistent, this.manageable, this.readable, this.writable, null, null);
        this.encrypted = this.attributeInfo.getEncryptedSetting();
        this.persistentValue = this.encrypted.decrypt(persistentValue);
    }

    public GBeanAttribute(GBeanInstance gbeanInstance, GAttributeInfo attributeInfo) throws InvalidConfigurationException {
        this.special = false;
        this.framework = false;
        if (gbeanInstance == null || attributeInfo == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        this.gbeanInstance = gbeanInstance;
        this.attributeInfo = attributeInfo;
        this.name = attributeInfo.getName();
        try {
            this.type = ClassLoading.loadClass(attributeInfo.getType(), gbeanInstance.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load attribute class: " + attributeInfo.getType(), e);
        }
        this.persistent = attributeInfo.isPersistent();
        this.manageable = attributeInfo.isManageable();
        this.encrypted = attributeInfo.getEncryptedSetting();
        this.readable = attributeInfo.isReadable();
        this.writable = attributeInfo.isWritable();
        if (attributeInfo instanceof DynamicGAttributeInfo) {
            this.dynamic = true;
            this.getInvoker = this.readable ? new DynamicGetterMethodInvoker(this.name) : null;
            this.setInvoker = this.writable ? new DynamicSetterMethodInvoker(this.name) : null;
        } else {
            this.dynamic = false;
            if (attributeInfo.getGetterName() != null) {
                try {
                    String getterName = attributeInfo.getGetterName();
                    Method getterMethod = gbeanInstance.getType().getMethod(getterName, null);
                    if (!getterMethod.getReturnType().equals(this.type)) {
                        if (getterMethod.getReturnType().getName().equals(this.type.getName())) {
                            throw new InvalidConfigurationException("Getter return type in wrong classloader: type: " + this.type + " wanted in classloader: " + this.type.getClassLoader() + " actual: " + getterMethod.getReturnType().getClassLoader());
                        }
                        throw new InvalidConfigurationException("Getter method of wrong type: " + getterMethod.getReturnType() + " expected " + this.getDescription());
                    }
                    if (AbstractGBeanReference.NO_PROXY) {
                        this.getInvoker = new ReflectionMethodInvoker(getterMethod);
                    }
                    this.getInvoker = new FastMethodInvoker(getterMethod);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidConfigurationException("Getter method not found " + this.getDescription(), e);
                }
            } else {
                this.getInvoker = null;
            }
            if (attributeInfo.getSetterName() != null) {
                try {
                    String setterName = attributeInfo.getSetterName();
                    Method setterMethod = gbeanInstance.getType().getMethod(setterName, this.type);
                    if (AbstractGBeanReference.NO_PROXY) {
                        this.setInvoker = new ReflectionMethodInvoker(setterMethod);
                    }
                    this.setInvoker = new FastMethodInvoker(setterMethod);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidConfigurationException("Setter method not found " + this.getDescription(), e);
                }
            } else {
                this.setInvoker = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public GAttributeInfo getAttributeInfo() {
        return this.attributeInfo;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isManageable() {
        return this.manageable;
    }

    public boolean isEncrypted() {
        return this.encrypted == EncryptionSetting.ENCRYPTED;
    }

    public EncryptionSetting getEncryptionSetting() {
        return this.encrypted;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public Object getPersistentValue() {
        if (!this.persistent && !this.special) {
            throw new IllegalStateException("Attribute is not persistent " + this.getDescription());
        }
        return this.persistentValue;
    }

    public void setPersistentValue(Object persistentValue) {
        if (!this.persistent && !this.special) {
            throw new IllegalStateException("Attribute is not persistent " + this.getDescription());
        }
        if (persistentValue == null && this.type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot assign null to a primitive attribute. " + this.getDescription());
        }
        this.persistentValue = this.encrypted.decrypt(persistentValue);
    }

    public Object getValue(Object target) throws Exception {
        if (!this.readable) {
            if (this.persistent) {
                return this.persistentValue;
            }
            throw new IllegalStateException("This attribute is not readable. " + this.getDescription());
        }
        if (this.special) {
            return this.persistentValue;
        }
        if (target == null && !this.framework) {
            throw new IllegalStateException("GBean does not have a target instance to invoke. " + this.getDescription());
        }
        Object value = this.getInvoker.invoke(target, null);
        return value;
    }

    public void setValue(Object target, Object value) throws Exception {
        if (!this.writable) {
            if (this.persistent) {
                throw new IllegalStateException("This persistent attribute is not modifable while the gbean is running. " + this.getDescription());
            }
            throw new IllegalStateException("This attribute is not writable. " + this.getDescription());
        }
        if (value == null && this.type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot assign null to a primitive attribute. " + this.getDescription());
        }
        if (target == null && !this.framework) {
            throw new IllegalStateException("GBean does not have a target instance to invoke. " + this.getDescription());
        }
        value = this.encrypted.decrypt(value);
        this.setInvoker.invoke(target, new Object[]{value});
    }

    public String getDescription() {
        return "Attribute Name: " + this.getName() + ", Type: " + this.getType() + ", GBeanInstance: " + this.gbeanInstance.getName();
    }

    public void inject(Object target) throws Exception {
        if ((this.persistent || this.special) && this.writable && null != this.persistentValue) {
            this.setValue(target, this.persistentValue);
        }
    }

    private static final class DynamicSetterMethodInvoker
    implements MethodInvoker {
        private final String name;

        public DynamicSetterMethodInvoker(String name) {
            this.name = name;
        }

        public Object invoke(Object target, Object[] arguments) throws Exception {
            ((DynamicGBean)target).setAttribute(this.name, arguments[0]);
            return null;
        }
    }

    private static final class DynamicGetterMethodInvoker
    implements MethodInvoker {
        private final String name;

        public DynamicGetterMethodInvoker(String name) {
            this.name = name;
        }

        public Object invoke(Object target, Object[] arguments) throws Exception {
            return ((DynamicGBean)target).getAttribute(this.name);
        }
    }
}

