/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.DynamicGOperationInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.gbean.runtime.FastMethodInvoker;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.MethodInvoker;
import org.apache.geronimo.gbean.runtime.ReflectionMethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;

public final class GBeanOperation {
    private final GBeanInstance gbeanInstance;
    private final String name;
    private final List parameterTypes;
    private final MethodInvoker methodInvoker;
    private final boolean framework;
    private final GOperationInfo operationInfo;

    static GBeanOperation createFrameworkOperation(GBeanInstance gbeanInstance, String name, List parameterTypes, MethodInvoker methodInvoker) {
        return new GBeanOperation(gbeanInstance, name, parameterTypes, methodInvoker);
    }

    private GBeanOperation(GBeanInstance gbeanInstance, String name, List parameterTypes, MethodInvoker methodInvoker) {
        this.framework = true;
        this.gbeanInstance = gbeanInstance;
        this.name = name;
        this.parameterTypes = Collections.unmodifiableList(new ArrayList(parameterTypes));
        this.methodInvoker = methodInvoker;
        this.operationInfo = new GOperationInfo(this.name, this.parameterTypes, "java.lang.Object");
    }

    public GBeanOperation(GBeanInstance gbeanInstance, GOperationInfo operationInfo) throws InvalidConfigurationException {
        this.framework = false;
        this.gbeanInstance = gbeanInstance;
        this.name = operationInfo.getName();
        this.operationInfo = operationInfo;
        this.parameterTypes = Collections.unmodifiableList(new ArrayList(operationInfo.getParameterList()));
        Class[] types = new Class[this.parameterTypes.size()];
        ClassLoader classLoader = gbeanInstance.getClassLoader();
        for (int i = 0; i < types.length; ++i) {
            String type = (String)this.parameterTypes.get(i);
            try {
                types[i] = ClassLoading.loadClass((String)this.parameterTypes.get(i), classLoader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigurationException("Could not load operation parameter class: name=" + operationInfo.getName() + " class=" + type, e);
            }
        }
        if (operationInfo instanceof DynamicGOperationInfo) {
            this.methodInvoker = new MethodInvoker(){
                private String[] types;
                {
                    this.types = GBeanOperation.this.parameterTypes.toArray(new String[GBeanOperation.this.parameterTypes.size()]);
                }

                public Object invoke(Object target, Object[] arguments) throws Exception {
                    DynamicGBean dynamicGBean = (DynamicGBean)target;
                    dynamicGBean.invoke(GBeanOperation.this.name, arguments, this.types);
                    return null;
                }
            };
        } else {
            try {
                Method javaMethod = gbeanInstance.getType().getMethod(operationInfo.getMethodName(), types);
                this.methodInvoker = AbstractGBeanReference.NO_PROXY ? new ReflectionMethodInvoker(javaMethod) : new FastMethodInvoker(javaMethod);
            }
            catch (Exception e) {
                StringBuilder b = new StringBuilder().append("Target does not have specified method (declared in a GBeanInfo operation): name=").append(operationInfo.getName()).append(" methodName=").append(operationInfo.getMethodName()).append(" returnType=").append(operationInfo.getReturnType()).append(" targetClass=").append(gbeanInstance.getType().getName());
                b.append("\ntargetClassClassLoader=").append(gbeanInstance.getType().getClassLoader());
                for (Class aType : types) {
                    b.append("\n  parameter type=").append(aType.getName()).append(" in classloader: ").append(aType.getClassLoader());
                }
                throw new InvalidConfigurationException(b.toString(), e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List getParameterTypes() {
        return this.parameterTypes;
    }

    public GOperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public Object invoke(Object target, Object[] arguments) throws Exception {
        return this.methodInvoker.invoke(target, arguments);
    }

    public String getDescription() {
        String signature = this.name + "(";
        Iterator iterator = this.parameterTypes.iterator();
        while (iterator.hasNext()) {
            String type = (String)iterator.next();
            signature = signature + type;
            if (!iterator.hasNext()) continue;
            signature = signature + ", ";
        }
        signature = signature + ")";
        return "Operation Signature: " + signature + ", GBeanInstance: " + this.gbeanInstance.getName();
    }
}

