/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelGBean;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.basic.BasicDependencyManager;
import org.apache.geronimo.kernel.basic.BasicLifecycleMonitor;
import org.apache.geronimo.kernel.basic.BasicProxyManager;
import org.apache.geronimo.kernel.basic.BasicRegistry;
import org.apache.geronimo.kernel.basic.LifecycleMonitorFlyweight;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicKernel
implements Kernel {
    private static final Logger log = LoggerFactory.getLogger(BasicKernel.class);
    private static final String[] NO_TYPES = new String[0];
    private static final Object[] NO_ARGS = new Object[0];
    private final String kernelName;
    private boolean running;
    private Date bootTime;
    private final BasicRegistry registry;
    private final LinkedList shutdownHooks = new LinkedList();
    private DependencyManager dependencyManager;
    private BasicLifecycleMonitor lifecycleMonitor;
    private LifecycleMonitor publicLifecycleMonitor;
    private ProxyManager proxyManager;
    private static final Naming INSTANCE = new Jsr77Naming();

    public BasicKernel(String kernelName) {
        if (kernelName.indexOf(58) >= 0 || kernelName.indexOf(42) >= 0 || kernelName.indexOf(63) >= 0) {
            throw new IllegalArgumentException("Kernel name may not contain a ':', '*' or '?' character");
        }
        this.kernelName = kernelName;
        this.registry = new BasicRegistry();
    }

    @Override
    public String getKernelName() {
        return this.kernelName;
    }

    @Override
    public Naming getNaming() {
        return INSTANCE;
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public LifecycleMonitor getLifecycleMonitor() {
        return this.publicLifecycleMonitor;
    }

    @Override
    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    @Override
    public Object getAttribute(ObjectName objectName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(objectName);
        return gbeanInstance.getAttribute(attributeName);
    }

    @Override
    public Object getAttribute(AbstractName abstractName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
        return gbeanInstance.getAttribute(attributeName);
    }

    @Override
    public Object getAttribute(String shortName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.getAttribute(shortName, null, attributeName);
    }

    @Override
    public Object getAttribute(Class type, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.getAttribute(null, type, attributeName);
    }

    @Override
    public Object getAttribute(String shortName, Class type, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getAttribute(attributeName);
    }

    @Override
    public void setAttribute(AbstractName abstractName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
        gbeanInstance.setAttribute(attributeName, attributeValue);
    }

    @Override
    public void setAttribute(String shortName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.setAttribute(shortName, null, attributeName, attributeValue);
    }

    @Override
    public void setAttribute(Class type, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.setAttribute(null, type, attributeName, attributeValue);
    }

    @Override
    public void setAttribute(String shortName, Class type, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.setAttribute(attributeName, attributeValue);
    }

    @Override
    public Object invoke(ObjectName objectName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(objectName, methodName, NO_ARGS, NO_TYPES);
    }

    @Override
    public Object invoke(AbstractName abstractName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(abstractName, methodName, NO_ARGS, NO_TYPES);
    }

    @Override
    public Object invoke(String shortName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(shortName, null, methodName, NO_ARGS, NO_TYPES);
    }

    @Override
    public Object invoke(Class type, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(null, type, methodName, NO_ARGS, NO_TYPES);
    }

    @Override
    public Object invoke(String shortName, Class type, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(shortName, type, methodName, NO_ARGS, NO_TYPES);
    }

    @Override
    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(objectName);
        return gbeanInstance.invoke(methodName, args, types);
    }

    @Override
    public Object invoke(AbstractName abstractName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
        return gbeanInstance.invoke(methodName, args, types);
    }

    @Override
    public Object invoke(String shortName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(shortName, null, methodName, args, types);
    }

    @Override
    public Object invoke(Class type, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(null, type, methodName, args, types);
    }

    @Override
    public Object invoke(String shortName, Class type, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.invoke(methodName, args, types);
    }

    @Override
    public boolean isLoaded(AbstractName name) {
        return this.registry.isRegistered(name);
    }

    @Override
    public boolean isLoaded(String shortName) {
        return this.isLoaded(shortName, null);
    }

    @Override
    public boolean isLoaded(Class type) {
        return this.isLoaded(null, type);
    }

    @Override
    public boolean isLoaded(String shortName, Class type) {
        try {
            this.registry.getGBeanInstance(shortName, type);
            return true;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }

    @Override
    public Object getGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        return this.getGBean(shortName, null);
    }

    @Override
    public <T> T getGBean(Class<T> type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        return this.getGBean(null, type);
    }

    @Override
    public <T> T getGBean(String shortName, Class<T> type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        if (gbeanInstance.getState() != 1) {
            throw new IllegalStateException("GBean is not running: " + gbeanInstance.getAbstractName());
        }
        return (T)gbeanInstance.getTarget();
    }

    @Override
    public Object getGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        if (gbeanInstance.getState() != 1) {
            throw new IllegalStateException("GBean is not running: " + name);
        }
        return gbeanInstance.getTarget();
    }

    @Override
    public Object getGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        if (gbeanInstance.getState() != 1) {
            throw new IllegalStateException("GBean is not running: " + name);
        }
        return gbeanInstance.getTarget();
    }

    @Override
    public GBeanInfo getGBeanInfo(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanInfo();
    }

    @Override
    public GBeanInfo getGBeanInfo(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanInfo();
    }

    @Override
    public GBeanInfo getGBeanInfo(String shortName) throws GBeanNotFoundException {
        return this.getGBeanInfo(shortName, null);
    }

    @Override
    public GBeanInfo getGBeanInfo(Class type) throws GBeanNotFoundException {
        return this.getGBeanInfo(null, type);
    }

    @Override
    public GBeanInfo getGBeanInfo(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getGBeanInfo();
    }

    @Override
    public GBeanData getGBeanData(AbstractName name) throws GBeanNotFoundException, InternalKernelException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanData();
    }

    @Override
    public GBeanData getGBeanData(String shortName) throws GBeanNotFoundException, InternalKernelException {
        return this.getGBeanData(shortName, null);
    }

    @Override
    public GBeanData getGBeanData(Class type) throws GBeanNotFoundException, InternalKernelException {
        return this.getGBeanData(null, type);
    }

    @Override
    public GBeanData getGBeanData(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getGBeanData();
    }

    @Override
    public void loadGBean(GBeanData gbeanData, ClassLoader classLoader) throws GBeanAlreadyExistsException, InternalKernelException {
        AbstractName abstractName = gbeanData.getAbstractName();
        Set<String> interfaces = gbeanData.getGBeanInfo().getInterfaces();
        LifecycleBroadcaster lifecycleBroadcaster = this.lifecycleMonitor.createLifecycleBroadcaster(abstractName, interfaces);
        GBeanInstance gbeanInstance = new GBeanInstance(gbeanData, this, this.dependencyManager, lifecycleBroadcaster, classLoader);
        this.registry.register(gbeanInstance);
        lifecycleBroadcaster.fireLoadedEvent();
    }

    @Override
    public void startGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.start();
    }

    @Override
    public void startGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startGBean(shortName, null);
    }

    @Override
    public void startGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startGBean(null, type);
    }

    @Override
    public void startGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.start();
    }

    @Override
    public void startRecursiveGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.startRecursive();
    }

    @Override
    public void startRecursiveGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startRecursiveGBean(shortName, null);
    }

    @Override
    public void startRecursiveGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.startRecursiveGBean(null, type);
    }

    @Override
    public void startRecursiveGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.startRecursive();
    }

    @Override
    public boolean isRunning(AbstractName name) {
        try {
            GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
            return gbeanInstance.getState() == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isRunning(String shortName) {
        return this.isRunning(shortName, null);
    }

    @Override
    public boolean isRunning(Class type) {
        return this.isRunning(null, type);
    }

    @Override
    public boolean isRunning(String shortName, Class type) {
        try {
            GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
            return gbeanInstance.getState() == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
    }

    @Override
    public void stopGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.stop();
    }

    @Override
    public void stopGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.stopGBean(shortName, null);
    }

    @Override
    public void stopGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.stopGBean(null, type);
    }

    @Override
    public void stopGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        gbeanInstance.stop();
    }

    @Override
    public void unloadGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.die();
        this.registry.unregister(name);
    }

    @Override
    public void unloadGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.unloadGBean(shortName, null);
    }

    @Override
    public void unloadGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        this.unloadGBean(null, type);
    }

    @Override
    public void unloadGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        AbstractName name = gbeanInstance.getAbstractName();
        gbeanInstance.die();
        this.registry.unregister(name);
    }

    @Override
    public int getGBeanState(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getState();
    }

    @Override
    public int getGBeanState(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getState();
    }

    @Override
    public int getGBeanState(String shortName) throws GBeanNotFoundException {
        return this.getGBeanState(shortName, null);
    }

    @Override
    public int getGBeanState(Class type) throws GBeanNotFoundException {
        return this.getGBeanState(null, type);
    }

    @Override
    public int getGBeanState(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getState();
    }

    @Override
    public long getGBeanStartTime(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getStartTime();
    }

    @Override
    public long getGBeanStartTime(String shortName) throws GBeanNotFoundException {
        return this.getGBeanStartTime(shortName, null);
    }

    @Override
    public long getGBeanStartTime(Class type) throws GBeanNotFoundException {
        return this.getGBeanStartTime(null, type);
    }

    @Override
    public long getGBeanStartTime(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getStartTime();
    }

    @Override
    public Set<AbstractName> listGBeans(ObjectName pattern) {
        Set gbeans = this.registry.listGBeans(pattern);
        HashSet<AbstractName> result = new HashSet<AbstractName>(gbeans.size());
        for (GBeanInstance instance : gbeans) {
            result.add(instance.getAbstractName());
        }
        return result;
    }

    @Override
    public Set<AbstractName> listGBeans(Set patterns) {
        HashSet<AbstractName> gbeans = new HashSet<AbstractName>();
        for (Object pattern : patterns) {
            if (pattern instanceof ObjectName) {
                gbeans.addAll(this.listGBeans((ObjectName)pattern));
                continue;
            }
            if (!(pattern instanceof AbstractNameQuery)) continue;
            gbeans.addAll(this.listGBeans((AbstractNameQuery)pattern));
        }
        return gbeans;
    }

    @Override
    public Set<AbstractName> listGBeans(AbstractNameQuery query) {
        Set gbeans = this.registry.listGBeans(query);
        HashSet<AbstractName> result = new HashSet<AbstractName>(gbeans.size());
        for (GBeanInstance instance : gbeans) {
            result.add(instance.getAbstractName());
        }
        return result;
    }

    public Set<AbstractName> listGBeansByInterface(String[] interfaces) {
        HashSet<AbstractName> gbeans = new HashSet<AbstractName>();
        Set<AbstractName> all = this.listGBeans((AbstractNameQuery)null);
        block2: for (AbstractName name : all) {
            try {
                GBeanInfo info = this.getGBeanInfo(name);
                Set<String> intfs = info.getInterfaces();
                for (String candidate : interfaces) {
                    if (!intfs.contains(candidate)) continue;
                    gbeans.add(name);
                    continue block2;
                }
            }
            catch (GBeanNotFoundException e) {
            }
        }
        return gbeans;
    }

    @Override
    public AbstractName getAbstractNameFor(Object service) {
        if (!this.running) {
            return null;
        }
        AbstractName name = this.proxyManager.getProxyTarget(service);
        if (name != null) {
            return name;
        }
        GBeanInstance gbeanInstance = this.registry.getGBeanInstanceByInstance(service);
        if (gbeanInstance != null) {
            return gbeanInstance.getAbstractName();
        }
        return null;
    }

    @Override
    public String getShortNameFor(Object service) {
        AbstractName name = this.getAbstractNameFor(service);
        if (name != null) {
            return (String)name.getName().get("name");
        }
        return null;
    }

    @Override
    public void boot() throws Exception {
        if (this.running) {
            return;
        }
        this.bootTime = new Date();
        log.debug("Starting boot");
        KernelRegistry.registerKernel(this);
        this.registry.start(this);
        this.lifecycleMonitor = new BasicLifecycleMonitor(this);
        this.publicLifecycleMonitor = new LifecycleMonitorFlyweight(this.lifecycleMonitor);
        this.dependencyManager = new BasicDependencyManager(this.publicLifecycleMonitor);
        this.proxyManager = new BasicProxyManager(this);
        GBeanData kernelGBeanData = new GBeanData(KERNEL_NAME, KernelGBean.GBEAN_INFO);
        this.loadGBean(kernelGBeanData, this.getClass().getClassLoader());
        this.startGBean(KERNEL_NAME);
        this.running = true;
        log.debug("Booted");
    }

    @Override
    public Date getBootTime() {
        return this.bootTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerShutdownHook(Runnable hook) {
        assert (hook != null) : "Shutdown hook was null";
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterShutdownHook(Runnable hook) {
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        log.debug("Starting kernel shutdown");
        this.notifyShutdownHooks();
        this.registry.stop();
        this.dependencyManager.close();
        this.dependencyManager = null;
        BasicKernel basicKernel = this;
        synchronized (basicKernel) {
            this.notify();
        }
        KernelRegistry.unregisterKernel(this);
        log.debug("Kernel shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdownHooks() {
        while (!this.shutdownHooks.isEmpty()) {
            Runnable hook;
            LinkedList linkedList = this.shutdownHooks;
            synchronized (linkedList) {
                hook = (Runnable)this.shutdownHooks.removeFirst();
            }
            try {
                hook.run();
            }
            catch (Throwable e) {
                log.warn("Error from kernel shutdown hook", e);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public ClassLoader getClassLoaderFor(AbstractName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getClassLoader();
    }

    @Override
    public ClassLoader getClassLoaderFor(String shortName) throws GBeanNotFoundException {
        return this.getClassLoaderFor(shortName, null);
    }

    @Override
    public ClassLoader getClassLoaderFor(Class type) throws GBeanNotFoundException {
        return this.getClassLoaderFor(null, type);
    }

    @Override
    public ClassLoader getClassLoaderFor(String shortName, Class type) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(shortName, type);
        return gbeanInstance.getClassLoader();
    }

    @Override
    public String getStateReason(AbstractName abstractName) {
        try {
            GBeanInstance gbeanInstance = this.registry.getGBeanInstance(abstractName);
            return gbeanInstance.getStateReason();
        }
        catch (GBeanNotFoundException e) {
            return null;
        }
    }
}

