/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.MultipleMatchesException;
import org.apache.geronimo.kernel.repository.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactResolver
implements ArtifactResolver {
    private final ArtifactManager artifactManager;
    private final Collection<? extends ListableRepository> repositories;
    private final Map<Artifact, Artifact> explicitResolution = new ConcurrentHashMap<Artifact, Artifact>();
    public static final GBeanInfo GBEAN_INFO;

    public DefaultArtifactResolver(ArtifactManager artifactManager, ListableRepository repository) {
        this.artifactManager = artifactManager;
        this.repositories = Collections.singleton(repository);
    }

    public DefaultArtifactResolver(ArtifactManager artifactManager, Collection<? extends ListableRepository> repositories, Map<Artifact, Artifact> explicitResolution) {
        this.artifactManager = artifactManager;
        this.repositories = repositories;
        if (explicitResolution != null) {
            this.explicitResolution.putAll(explicitResolution);
        }
    }

    protected Map<Artifact, Artifact> getExplicitResolution() {
        return this.explicitResolution;
    }

    @Override
    public Artifact generateArtifact(Artifact source, String defaultType) {
        if (source.isResolved()) {
            Artifact deAliased = this.explicitResolution.get(source);
            if (deAliased != null) {
                return deAliased;
            }
            return source;
        }
        String groupId = source.getGroupId() == null ? "default" : source.getGroupId();
        String artifactId = source.getArtifactId();
        String type = source.getType() == null ? defaultType : source.getType();
        Version version = source.getVersion() == null ? new Version(Long.toString(System.currentTimeMillis())) : source.getVersion();
        return new Artifact(groupId, artifactId, version, type);
    }

    @Override
    public Artifact queryArtifact(Artifact artifact) throws MultipleMatchesException {
        Artifact[] all = this.queryArtifacts(artifact);
        if (all.length > 1) {
            throw new MultipleMatchesException(artifact);
        }
        return all.length == 0 ? null : all[0];
    }

    @Override
    public Artifact[] queryArtifacts(Artifact artifact) {
        Artifact deAliased = this.explicitResolution.get(artifact);
        if (deAliased != null) {
            artifact = deAliased;
        }
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>();
        for (ListableRepository listableRepository : this.repositories) {
            set.addAll(listableRepository.list(artifact));
        }
        return set.toArray(new Artifact[set.size()]);
    }

    @Override
    public LinkedHashSet<Artifact> resolveInClassLoader(Collection<Artifact> artifacts) throws MissingDependencyException {
        return this.resolveInClassLoader(artifacts, Collections.<Configuration>emptySet());
    }

    @Override
    public LinkedHashSet<Artifact> resolveInClassLoader(Collection<Artifact> artifacts, Collection<Configuration> parentConfigurations) throws MissingDependencyException {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!artifact.isResolved()) {
                artifact = this.resolveInClassLoader(artifact, parentConfigurations);
            }
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    @Override
    public Artifact resolveInClassLoader(Artifact source) throws MissingDependencyException {
        return this.resolveInClassLoader(source, Collections.<Configuration>emptySet());
    }

    @Override
    public Artifact resolveInClassLoader(Artifact source, Collection<Configuration> parentConfigurations) throws MissingDependencyException {
        Artifact working = this.resolveVersion(parentConfigurations, source);
        if (working == null || !working.isResolved()) {
            throw new MissingDependencyException(source);
        }
        return working;
    }

    private Artifact resolveVersion(Collection<Configuration> parentConfigurations, Artifact working) {
        Artifact deAliased = this.explicitResolution.get(working);
        if (deAliased != null) {
            working = deAliased;
        }
        if (working.isResolved()) {
            return working;
        }
        SortedSet existingArtifacts = this.artifactManager != null ? this.artifactManager.getLoadedArtifacts(working) : new TreeSet();
        if (existingArtifacts.size() == 1) {
            return (Artifact)existingArtifacts.first();
        }
        if (existingArtifacts.size() == 0) {
            TreeSet<Artifact> list = new TreeSet<Artifact>();
            for (ListableRepository listableRepository : this.repositories) {
                list.addAll(listableRepository.list(working));
            }
            if (list.isEmpty()) {
                if ("xbean-naming".equals(working.getArtifactId())) {
                    return new Artifact("org.apache.xbean", "xbean-naming", "2.8", "jar");
                }
                return null;
            }
            return (Artifact)list.last();
        }
        Artifact artifact = this.searchParents(parentConfigurations, working);
        if (artifact != null) {
            return artifact;
        }
        return (Artifact)existingArtifacts.last();
    }

    private Artifact searchParents(Collection<Configuration> parentConfigurations, Artifact working) {
        for (Configuration configuration : parentConfigurations) {
            Artifact artifact;
            if (this.matches(configuration.getId(), working)) {
                return configuration.getId();
            }
            Environment environment = configuration.getEnvironment();
            if (environment.getClassLoadingRules().isInverseClassLoading()) {
                artifact = this.getArtifactVersion(configuration.getDependencies(), working);
                if (artifact != null) {
                    return artifact;
                }
                artifact = this.searchParents(configuration.getClassParents(), working);
                if (artifact == null) continue;
                return artifact;
            }
            artifact = this.searchParents(configuration.getClassParents(), working);
            if (artifact != null) {
                return artifact;
            }
            artifact = this.getArtifactVersion(configuration.getDependencies(), working);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    private Artifact getArtifactVersion(Collection<Artifact> artifacts, Artifact query) {
        for (Artifact artifact : artifacts) {
            if (!this.matches(artifact, query)) continue;
            return artifact;
        }
        return null;
    }

    private boolean matches(Artifact candidate, Artifact query) {
        return query.matches(candidate);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DefaultArtifactResolver.class, "ArtifactResolver");
        infoFactory.addAttribute("explicitResolution", Map.class, true, true);
        infoFactory.addReference("ArtifactManager", ArtifactManager.class, "ArtifactManager");
        infoFactory.addReference("Repositories", ListableRepository.class, "Repository");
        infoFactory.addInterface(ArtifactResolver.class);
        infoFactory.setConstructor(new String[]{"ArtifactManager", "Repositories", "explicitResolution"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

