/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.ImportType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment
implements Serializable {
    private static final long serialVersionUID = 7075760873629376317L;
    private Artifact configId;
    private final LinkedHashSet dependencies = new LinkedHashSet();
    private final ClassLoadingRules classLoadingRules;
    private boolean suppressDefaultEnvironment;

    public Environment() {
        this.classLoadingRules = new ClassLoadingRules();
    }

    public Environment(Artifact configId) {
        this.configId = configId;
        this.classLoadingRules = new ClassLoadingRules();
    }

    public Environment(Environment environment) {
        this.configId = environment.getConfigId();
        this.dependencies.addAll(environment.dependencies);
        this.suppressDefaultEnvironment = environment.isSuppressDefaultEnvironment();
        this.classLoadingRules = environment.classLoadingRules;
    }

    public Artifact getConfigId() {
        return this.configId;
    }

    public void setConfigId(Artifact configId) {
        this.configId = configId;
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(new ArrayList(this.dependencies));
    }

    public void addDependency(Artifact artifact, ImportType importType) {
        this.dependencies.add(new Dependency(artifact, importType));
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependencies(Collection dependencies) {
        for (Dependency dependency : dependencies) {
            this.addDependency(dependency);
        }
    }

    public void setDependencies(Collection dependencies) {
        this.dependencies.clear();
        this.addDependencies(dependencies);
    }

    public ClassLoadingRules getClassLoadingRules() {
        return this.classLoadingRules;
    }

    public boolean isSuppressDefaultEnvironment() {
        return this.suppressDefaultEnvironment;
    }

    public void setSuppressDefaultEnvironment(boolean suppressDefaultEnvironment) {
        this.suppressDefaultEnvironment = suppressDefaultEnvironment;
    }
}

