/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geronimo.gbean.BasicGBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanInfoFactoryException;
import org.apache.geronimo.gbean.GBeanInfoFactoryRegistry;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoFactory;
import org.osgi.framework.Bundle;

public class MultiGBeanInfoFactory
implements GBeanInfoFactory,
GBeanInfoFactoryRegistry {
    private static final CopyOnWriteArrayList<GBeanInfoFactory> FACTORIES = new CopyOnWriteArrayList();

    @Override
    public void registerFactory(GBeanInfoFactory factory) {
        FACTORIES.add(0, factory);
    }

    @Override
    public void unregisterFactory(GBeanInfoFactory factory) {
        FACTORIES.remove(factory);
    }

    @Override
    public GBeanInfo getGBeanInfo(Class clazz) throws GBeanInfoFactoryException {
        ArrayList<GBeanInfoFactoryException> errors = new ArrayList<GBeanInfoFactoryException>(2);
        for (GBeanInfoFactory factory : FACTORIES) {
            try {
                return factory.getGBeanInfo(clazz);
            }
            catch (GBeanInfoFactoryException e) {
                errors.add(e);
            }
        }
        throw new GBeanInfoFactoryException("Cannot create a GBeanInfo for [" + clazz + "], errors: " + errors, (Throwable)errors.get(errors.size() - 1));
    }

    @Override
    public GBeanInfo getGBeanInfo(String className, Bundle bundle) throws GBeanInfoFactoryException {
        ArrayList<GBeanInfoFactoryException> errors = new ArrayList<GBeanInfoFactoryException>(2);
        for (GBeanInfoFactory factory : FACTORIES) {
            try {
                return factory.getGBeanInfo(className, bundle);
            }
            catch (GBeanInfoFactoryException e) {
                errors.add(e);
            }
        }
        throw new GBeanInfoFactoryException("Cannot create a GBeanInfo for [" + className + "], errors: " + errors, (Throwable)errors.get(errors.size() - 1));
    }

    static {
        FACTORIES.add(new BasicGBeanInfoFactory());
        FACTORIES.add(new AnnotationGBeanInfoFactory());
    }
}

