/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geronimo.kernel.repository.AbstractRepository;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.WritableListableRepository;

public class Maven2Repository
extends AbstractRepository
implements WritableListableRepository {
    public Maven2Repository(File rootFile) {
        super(rootFile);
    }

    @Override
    public File getLocation(Artifact artifact) {
        if (!artifact.isResolved()) {
            throw new IllegalArgumentException("Artifact " + artifact + " is not fully resolved");
        }
        File path = new File(this.rootFile, artifact.getGroupId().replace('.', File.separatorChar));
        path = new File(path, artifact.getArtifactId());
        path = new File(path, artifact.getVersion().toString());
        path = new File(path, artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getType());
        return path;
    }

    public SortedSet list() {
        return this.listInternal(null, null, null);
    }

    public SortedSet list(Artifact query) {
        if (query.getGroupId() != null) {
            File path = new File(this.rootFile, query.getGroupId().replace('.', File.separatorChar));
            if (!(path = new File(path, query.getArtifactId())).canRead() || !path.isDirectory()) {
                return new TreeSet();
            }
            TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
            File[] versionDirs = path.listFiles();
            for (int i = 0; i < versionDirs.length; ++i) {
                File versionDir = versionDirs[i];
                if (!versionDir.canRead() || !versionDir.isDirectory()) continue;
                String version = versionDir.getName();
                if (query.getVersion() != null && !query.getVersion().toString().equals(version)) continue;
                final String filePrefix = query.getArtifactId() + "-" + version + ".";
                File[] list = versionDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(filePrefix);
                    }
                });
                for (int j = 0; j < list.length; ++j) {
                    File file = list[j];
                    String end = file.getName().substring(filePrefix.length());
                    if (query.getType() != null && !query.getType().equals(end) || end.indexOf(46) >= 0) continue;
                    artifacts.add(new Artifact(query.getGroupId(), query.getArtifactId(), version, end));
                }
            }
            return artifacts;
        }
        return this.listInternal(query.getArtifactId(), query.getType(), query.getVersion() == null ? null : query.getVersion().toString());
    }

    private SortedSet listInternal(String artifactMatch, String typeMatch, String versionMatch) {
        TreeSet artifacts = new TreeSet();
        File[] groupIds = this.rootFile.listFiles();
        for (int i = 0; i < groupIds.length; ++i) {
            File groupId = groupIds[i];
            if (!groupId.canRead() || !groupId.isDirectory()) continue;
            File[] versionDirs = groupId.listFiles();
            for (int j = 0; j < versionDirs.length; ++j) {
                File versionDir = versionDirs[j];
                if (!versionDir.canRead() || !versionDir.isDirectory()) continue;
                artifacts.addAll(this.getArtifacts(null, versionDir, artifactMatch, typeMatch, versionMatch));
            }
        }
        return artifacts;
    }

    private List getArtifacts(String groupId, File versionDir, String artifactMatch, String typeMatch, String versionMatch) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        String artifactId = versionDir.getParentFile().getName();
        File[] files = versionDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String type;
            File file = files[i];
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                File test = new File(file, "META-INF");
                if (test.exists() && test.isDirectory() && test.canRead() && groupId != null) {
                    String type2;
                    String version = versionDir.getName();
                    String fileHeader = artifactId + "-" + version + ".";
                    String fileName = file.getName();
                    if (!fileName.startsWith(fileHeader) || (type2 = fileName.substring(fileHeader.length())).endsWith(".sha1") || type2.endsWith(".md5") || artifactMatch != null && !artifactMatch.equals(artifactId) || typeMatch != null && !typeMatch.equals(type2) || versionMatch != null && !versionMatch.equals(version)) continue;
                    artifacts.add(new Artifact(groupId, artifactId, version, type2));
                    continue;
                }
                String nextGroupId = groupId == null ? artifactId : groupId + "." + artifactId;
                artifacts.addAll(this.getArtifacts(nextGroupId, file, artifactMatch, typeMatch, versionMatch));
                continue;
            }
            if (groupId == null) continue;
            String version = versionDir.getName();
            String fileHeader = artifactId + "-" + version + ".";
            String fileName = file.getName();
            if (!fileName.startsWith(fileHeader) || (type = fileName.substring(fileHeader.length())).endsWith(".sha1") || type.endsWith(".md5") || artifactMatch != null && !artifactMatch.equals(artifactId) || typeMatch != null && !typeMatch.equals(type) || versionMatch != null && !versionMatch.equals(version)) continue;
            artifacts.add(new Artifact(groupId, artifactId, version, type));
        }
        return artifacts;
    }
}

