/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.util.Main;
import org.osgi.framework.BundleContext;

public class MainConfigurationBootstrapper {
    protected Kernel kernel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(MainConfigurationBootstrapper bootstrapper, Object opaque, BundleContext bundleContext) {
        int exitCode;
        Main main = bootstrapper.getMain(bundleContext);
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newTCCL = main.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(newTCCL);
            exitCode = main.execute(opaque);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return exitCode;
    }

    public Main getMain(BundleContext bundleContext) {
        try {
            this.bootKernel(bundleContext);
            this.loadBootConfiguration(bundleContext);
            this.loadPersistentConfigurations();
            return this.getMain();
        }
        catch (Exception e) {
            if (null != this.kernel) {
                this.kernel.shutdown();
            }
            e.printStackTrace();
            System.exit(1);
            throw new AssertionError();
        }
    }

    public void bootKernel(BundleContext bundleContext) throws Exception {
        this.kernel = KernelFactory.newInstance(bundleContext).createKernel("MainBootstrapper");
        this.kernel.boot();
        Runtime.getRuntime().addShutdownHook(new Thread("MainBootstrapper shutdown thread"){

            @Override
            public void run() {
                MainConfigurationBootstrapper.this.kernel.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootConfiguration(BundleContext bundleContext) throws Exception {
        InputStream in = bundleContext.getBundle().getResource("META-INF/config.ser").openStream();
        try {
            ConfigurationUtil.loadBootstrapConfiguration(this.kernel, in, bundleContext, true);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadPersistentConfigurations() throws Exception {
    }

    public Main getMain() throws Exception {
        return this.kernel.getGBean(Main.class);
    }

    public Kernel getKernel() {
        return this.kernel;
    }
}

