/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geronimo.kernel.config.ConfigurationStatus;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;

public class ConfigurationModel {
    private final Map<Artifact, ConfigurationStatus> configurations = new TreeMap<Artifact, ConfigurationStatus>();

    public void addConfiguration(Artifact configurationId, Set<Artifact> loadParentIds, Set<Artifact> startParentIds) throws NoSuchConfigException {
        Set<ConfigurationStatus> startParents = this.getStatuses(startParentIds);
        LinkedHashSet<ConfigurationStatus> loadParents = new LinkedHashSet<ConfigurationStatus>(startParents);
        loadParents.addAll(this.getStatuses(loadParentIds));
        ConfigurationStatus configurationStatus = new ConfigurationStatus(configurationId, loadParents, startParents);
        this.configurations.put(configurationId, configurationStatus);
    }

    private Set<ConfigurationStatus> getStatuses(Set<Artifact> configurationIds) throws NoSuchConfigException {
        LinkedHashSet<ConfigurationStatus> statuses = new LinkedHashSet<ConfigurationStatus>(configurationIds.size());
        for (Artifact configurationId : configurationIds) {
            ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
            if (configurationStatus == null) {
                throw new NoSuchConfigException(configurationId);
            }
            statuses.add(configurationStatus);
        }
        return statuses;
    }

    public void removeConfiguration(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        configurationStatus.destroy();
        this.configurations.remove(configurationId);
    }

    public boolean containsConfiguration(Artifact configurationId) {
        return this.configurations.containsKey(configurationId);
    }

    public void upgradeConfiguration(Artifact existingId, Artifact newId, Set<Artifact> newLoadParentIds, Set<Artifact> newStartParentIds) throws NoSuchConfigException {
        Set<ConfigurationStatus> newStartParents = this.getStatuses(newStartParentIds);
        LinkedHashSet<ConfigurationStatus> newLoadParents = new LinkedHashSet<ConfigurationStatus>(newStartParents);
        newLoadParents.addAll(this.getStatuses(newLoadParentIds));
        ConfigurationStatus configurationStatus = this.configurations.remove(existingId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(existingId);
        }
        this.configurations.put(newId, configurationStatus);
        configurationStatus.upgrade(newId, newLoadParents, newStartParents);
    }

    public boolean isLoaded(Artifact configurationId) {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus != null) {
            return configurationStatus.isLoaded();
        }
        return false;
    }

    public Artifact[] getLoaded(Artifact query) {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        for (Map.Entry<Artifact, ConfigurationStatus> entry : this.configurations.entrySet()) {
            Artifact test = entry.getKey();
            ConfigurationStatus status = entry.getValue();
            if (!query.matches(test) || !status.isLoaded()) continue;
            results.add(test);
        }
        return results.toArray(new Artifact[results.size()]);
    }

    public boolean isStarted(Artifact configurationId) {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus != null) {
            return configurationStatus.isStarted();
        }
        return false;
    }

    public Artifact[] getStarted(Artifact query) {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        for (Map.Entry<Artifact, ConfigurationStatus> entry : this.configurations.entrySet()) {
            Artifact test = entry.getKey();
            ConfigurationStatus status = entry.getValue();
            if (!query.matches(test) || !status.isStarted()) continue;
            results.add(test);
        }
        return results.toArray(new Artifact[results.size()]);
    }

    public LinkedHashSet<Artifact> load(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.load();
    }

    public LinkedHashSet<Artifact> start(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.start();
    }

    public LinkedHashSet<Artifact> stop(Artifact configurationId) throws NoSuchConfigException {
        return this.stop(configurationId, true);
    }

    public LinkedHashSet<Artifact> stop(Artifact configurationId, boolean gc) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.stop(gc);
    }

    public LinkedHashSet<Artifact> restart(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.restart();
    }

    public LinkedHashSet<Artifact> unload(Artifact configurationId) throws NoSuchConfigException {
        return this.unload(configurationId, true);
    }

    public LinkedHashSet<Artifact> unload(Artifact configurationId, boolean gc) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.unload(gc);
    }

    public LinkedHashSet<Artifact> reload(Artifact existingConfigurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = this.configurations.get(existingConfigurationId);
        if (configurationStatus == null) {
            return new LinkedHashSet<Artifact>();
        }
        return configurationStatus.reload();
    }

    public Set<Artifact> getLoaded() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (ConfigurationStatus status : this.configurations.values()) {
            if (!status.isLoaded()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public Set<Artifact> getStarted() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (ConfigurationStatus status : this.configurations.values()) {
            if (!status.isStarted()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public Set<Artifact> getUserLoaded() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (ConfigurationStatus status : this.configurations.values()) {
            if (!status.isUserLoaded()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public Set<Artifact> getUserStarted() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (ConfigurationStatus status : this.configurations.values()) {
            if (!status.isUserStarted()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public LinkedHashSet<Artifact> getStartedChildren(Artifact configurationId) {
        ConfigurationStatus configurationStatus = this.configurations.get(configurationId);
        if (configurationStatus == null) {
            return new LinkedHashSet<Artifact>();
        }
        return configurationStatus.getStartedChildren();
    }
}

