/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.osgi;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.CircularReferencesException;
import org.apache.geronimo.kernel.util.IllegalNodeConfigException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationActivator.class);
    private Artifact id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        ServiceReference kernelReference = null;
        InputStream in = null;
        try {
            kernelReference = bundleContext.getServiceReference(Kernel.class.getName());
            if (kernelReference == null) {
                return;
            }
            Kernel kernel = (Kernel)bundleContext.getService(kernelReference);
            ConfigurationManager manager = ConfigurationUtil.getConfigurationManager(kernel);
            Bundle bundle = bundleContext.getBundle();
            in = bundle.getEntry("META-INF/config.ser").openStream();
            ConfigurationData data = ConfigurationUtil.readConfigurationData(in);
            data.setBundleContext(bundleContext);
            manager.loadConfiguration(data);
            this.id = data.getId();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (kernelReference != null) {
                try {
                    bundleContext.ungetService(kernelReference);
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        ServiceReference kernelReference = null;
        try {
            kernelReference = bundleContext.getServiceReference(Kernel.class.getName());
            if (kernelReference == null) {
                return;
            }
            Kernel kernel = (Kernel)bundleContext.getService(kernelReference);
            ConfigurationManager manager = ConfigurationUtil.getConfigurationManager(kernel);
            Configuration configuration = manager.getConfiguration(this.id);
            if (configuration != null) {
                this.stopRecursive(kernel, configuration);
            }
            AbstractName name = Configuration.getConfigurationAbstractName(this.id);
            try {
                kernel.stopGBean(name);
            }
            catch (GBeanNotFoundException e) {
            }
            catch (InternalKernelException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                kernel.unloadGBean(name);
            }
            catch (GBeanNotFoundException e) {
            }
            catch (InternalKernelException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        finally {
            if (kernelReference != null) {
                try {
                    bundleContext.ungetService(kernelReference);
                }
                catch (Exception e) {}
            }
        }
    }

    private void stopRecursive(Kernel kernel, Configuration configuration) {
        AbstractName gbeanName;
        Collection<GBeanData> gbeans;
        for (Configuration childConfiguration : configuration.getChildren()) {
            this.stopRecursive(kernel, childConfiguration);
        }
        try {
            List<GBeanData> sortedGBeans = ConfigurationUtil.sortGBeanDataByDependency(configuration.getGBeans().values());
            Collections.reverse(sortedGBeans);
            gbeans = sortedGBeans;
        }
        catch (IllegalNodeConfigException e) {
            gbeans = configuration.getGBeans().values();
        }
        catch (CircularReferencesException e) {
            gbeans = configuration.getGBeans().values();
        }
        for (GBeanData gbeanData : gbeans) {
            gbeanName = gbeanData.getAbstractName();
            try {
                kernel.stopGBean(gbeanName);
            }
            catch (GBeanNotFoundException ignored) {
            }
            catch (IllegalStateException ignored) {
            }
            catch (InternalKernelException kernelException) {
                logger.debug("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName, (Throwable)kernelException);
            }
        }
        for (GBeanData gbeanData : gbeans) {
            gbeanName = gbeanData.getAbstractName();
            try {
                kernel.unloadGBean(gbeanName);
            }
            catch (GBeanNotFoundException ignored) {
            }
            catch (IllegalStateException ignored) {
            }
            catch (InternalKernelException kernelException) {
                logger.debug("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName, (Throwable)kernelException);
            }
        }
    }
}

