/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;

public class UnpackArtifactTypeHandler
implements ArtifactTypeHandler {
    private static final int TRANSFER_NOTIFICATION_SIZE = 10240;
    private static final int TRANSFER_BUF_SIZE = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(InputStream source, int size, Artifact artifact, FileWriteMonitor monitor, File target) throws IOException {
        File parent = target.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create directory " + parent.getAbsolutePath());
        }
        if (monitor != null) {
            monitor.writeStarted(artifact.toString(), size);
        }
        int total = 0;
        ZipInputStream in = new ZipInputStream(source);
        try {
            int threshold = 10240;
            byte[] buffer = new byte[10240];
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                File file = new File(target, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else if (!entry.getName().equals("META-INF/startup-jar")) {
                    file.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int count;
                        while ((count = in.read(buffer)) > 0) {
                            ((OutputStream)out).write(buffer, 0, count);
                            if (monitor == null || (total += count) <= threshold) continue;
                            threshold += 10240;
                            monitor.writeProgress(total);
                        }
                    }
                    finally {
                        IOUtils.flush(out);
                        ((OutputStream)out).close();
                    }
                    in.closeEntry();
                }
                entry = in.getNextEntry();
            }
        }
        catch (IOException e) {
            FileUtils.recursiveDelete(target);
            throw e;
        }
        finally {
            in.close();
            if (monitor != null) {
                monitor.writeComplete(total);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(File source, Artifact artifactId, FileWriteMonitor monitor, File target) throws IOException {
        if (source.isFile()) {
            long size = monitor == null ? -1L : this.getJarSize(source);
            FileInputStream is = new FileInputStream(source);
            try {
                this.install(is, (int)size, artifactId, monitor, target);
            }
            finally {
                IOUtils.close(is);
            }
        } else {
            FileUtils.recursiveCopy(source, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getJarSize(File source) throws IOException {
        long size = 0L;
        ZipFile zip = null;
        try {
            zip = new ZipFile(source);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                size += entry.getSize();
            }
        }
        catch (ZipException ze) {
            try {
                size = (int)source.length();
            }
            catch (Throwable throwable) {
                JarUtils.close(zip);
                throw throwable;
            }
            JarUtils.close(zip);
        }
        JarUtils.close(zip);
        return size;
    }
}

