/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.util.Collection;

public class JoinUtils {
    public static String join(String delimiter, Collection collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            sb.append(obj).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static String join(String delimiter, Object ... collection) {
        if (collection.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            sb.append(obj).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static <T> String join(String delimiter, NameCallback<T> nameCallback, T ... collection) {
        if (collection.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T obj : collection) {
            sb.append(nameCallback.getName(obj)).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static <T> String join(String delimiter, NameCallback<T> nameCallback, Collection<T> collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T obj : collection) {
            sb.append(nameCallback.getName(obj)).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static interface NameCallback<T> {
        public String getName(T var1);
    }
}

