/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.io.Serializable;

public class SubjectId
implements Serializable {
    private final Long subjectId;
    private final byte[] hash;
    private transient int hashCode;
    private transient String name;
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SubjectId(Long subjectId, byte[] hash) {
        if (subjectId == null) {
            throw new IllegalArgumentException("subjectId cannot be null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("hash cannot be null");
        }
        this.subjectId = subjectId;
        this.hash = hash;
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubjectId)) {
            return false;
        }
        SubjectId another = (SubjectId)obj;
        if (!another.subjectId.equals(this.subjectId)) {
            return false;
        }
        for (int i = 0; i < this.hash.length; ++i) {
            if (another.hash[i] == this.hash[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            buffer.append(this.subjectId);
            buffer.append(":0x");
            for (int i = 0; i < this.hash.length; ++i) {
                buffer.append(HEXCHAR[this.hash[i] >>> 4 & 0xF]);
                buffer.append(HEXCHAR[this.hash[i] & 0xF]);
            }
            buffer.append(']');
            this.name = buffer.toString();
        }
        return this.name;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (int i = 0; i < this.hash.length; ++i) {
                this.hashCode ^= this.hash[i];
            }
            this.hashCode ^= this.subjectId.hashCode();
        }
        return this.hashCode;
    }
}

