/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.credentialstore;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Class<Principal> principalClass;
    private List<String> allowedNames;
    private String name;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        ClassLoader classLoader = (ClassLoader)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER");
        String principalClassName = (String)options.get("principalClass");
        try {
            this.principalClass = classLoader.loadClass(principalClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(principalClassName + " not found", e);
        }
        String allNames = (String)options.get("principalNames");
        this.allowedNames = Arrays.asList(allNames.split(","));
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback callback = new NameCallback("foo");
        try {
            this.callbackHandler.handle(new Callback[]{callback});
        }
        catch (IOException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        this.name = callback.getName();
        if (this.allowedNames.contains(this.name)) {
            return true;
        }
        throw new FailedLoginException("name not recognized " + this.name);
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            Constructor<Principal> c = this.principalClass.getConstructor(String.class);
            Principal principal = c.newInstance(this.name);
            this.subject.getPrincipals().add(principal);
            return true;
        }
        catch (InstantiationException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        catch (NoSuchMethodException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }
}

