/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.WrappingLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassOptionLoginModule
implements LoginModule {
    public static final String CLASS_OPTION = WrappingLoginModule.class.getName() + ".LoginModuleClass";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList(CLASS_OPTION));
    private LoginModule delegate;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Class lmClass = (Class)options.get(CLASS_OPTION);
        try {
            this.delegate = (LoginModule)lmClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create login module instance", e);
        }
        this.delegate.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this.delegate.login();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.delegate.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.delegate.commit();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.delegate.logout();
    }
}

