/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredIdentityNamedUsernamePasswordLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(ConfiguredIdentityNamedUsernamePasswordLoginModule.class);
    public static final String CREDENTIAL_NAME = "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Name";
    public static final String USER_NAME = "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Username";
    public static final String PASSWORD = "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Password";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Name", "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Username", "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Password"));
    private Subject subject;
    private NamedUsernamePasswordCredential namedUsernamePasswordCredential;
    private String name;
    private String username;
    private String password;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
        this.name = (String)options.get(CREDENTIAL_NAME);
        this.username = (String)options.get(USER_NAME);
        this.password = (String)options.get(PASSWORD);
    }

    public boolean login() throws LoginException {
        return false;
    }

    public boolean commit() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        this.namedUsernamePasswordCredential = new NamedUsernamePasswordCredential(this.username, this.password.toCharArray(), this.name);
        this.subject.getPrivateCredentials().add(this.namedUsernamePasswordCredential);
        return false;
    }

    public boolean abort() throws LoginException {
        return this.logout();
    }

    public boolean logout() throws LoginException {
        if (this.namedUsernamePasswordCredential == null) {
            return false;
        }
        Set<Object> pvtCreds = this.subject.getPrivateCredentials();
        if (!this.subject.isReadOnly()) {
            pvtCreds.remove(this.namedUsernamePasswordCredential);
        }
        try {
            this.namedUsernamePasswordCredential.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        this.namedUsernamePasswordCredential = null;
        return false;
    }
}

