/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.ClassOptionLoginModule;
import org.apache.geronimo.security.jaas.JaasLoginModuleChain;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.LoginModuleSettings;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.system.serverinfo.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasLoginModuleUse
implements JaasLoginModuleChain {
    public static final String KERNEL_NAME_LM_OPTION = "org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL";
    public static final String SERVERINFO_LM_OPTION = "org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO";
    public static final String CLASSLOADER_LM_OPTION = "org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL", "org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO", "org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER"));
    private final LoginModuleSettings loginModule;
    private final JaasLoginModuleUse next;
    private LoginModuleControlFlag controlFlag;
    public static final GBeanInfo GBEAN_INFO;

    public JaasLoginModuleUse() {
        this.loginModule = null;
        this.next = null;
        this.controlFlag = null;
    }

    public JaasLoginModuleUse(LoginModuleSettings loginModule, JaasLoginModuleUse next, LoginModuleControlFlag controlFlag) {
        this.loginModule = loginModule;
        this.next = next;
        this.controlFlag = controlFlag;
    }

    @Override
    public LoginModuleSettings getLoginModule() {
        return this.loginModule;
    }

    @Override
    public JaasLoginModuleChain getNext() {
        return this.next;
    }

    @Override
    public LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    @Override
    public void setControlFlag(LoginModuleControlFlag controlFlag) {
        this.controlFlag = controlFlag;
    }

    public void configure(Set<String> domainNames, List<AppConfigurationEntry> loginModuleConfigurations, String realmName, Kernel kernel, ServerInfo serverInfo, ClassLoader classLoader) throws ClassNotFoundException {
        AppConfigurationEntry entry;
        Map<String, Object> suppliedOptions = this.loginModule.getOptions();
        HashMap<Object, Object> options = suppliedOptions != null ? new HashMap<String, Object>(suppliedOptions) : new HashMap();
        if (kernel != null && !options.containsKey(KERNEL_NAME_LM_OPTION)) {
            options.put(KERNEL_NAME_LM_OPTION, kernel.getKernelName());
        }
        if (serverInfo != null && !options.containsKey(SERVERINFO_LM_OPTION)) {
            options.put(SERVERINFO_LM_OPTION, serverInfo);
        }
        if (!options.containsKey(CLASSLOADER_LM_OPTION)) {
            options.put(CLASSLOADER_LM_OPTION, classLoader);
        }
        Class<?> loginModuleClass = classLoader.loadClass(this.loginModule.getLoginModuleClass());
        options.put(WrappingLoginModule.CLASS_OPTION, loginModuleClass);
        if (this.loginModule.isWrapPrincipals()) {
            options.put(WrappingLoginModule.DOMAIN_OPTION, this.loginModule.getLoginDomainName());
            options.put(WrappingLoginModule.REALM_OPTION, realmName);
            entry = new AppConfigurationEntry(WrappingLoginModule.class.getName(), this.controlFlag.getFlag(), options);
        } else {
            entry = new AppConfigurationEntry(ClassOptionLoginModule.class.getName(), this.controlFlag.getFlag(), options);
        }
        if (this.loginModule.getLoginDomainName() != null) {
            if (domainNames.contains(this.loginModule.getLoginDomainName())) {
                throw new IllegalStateException("Error in realm: one security realm cannot contain multiple login modules for the same login domain");
            }
            domainNames.add(this.loginModule.getLoginDomainName());
        }
        loginModuleConfigurations.add(entry);
        if (this.next != null) {
            this.next.configure(domainNames, loginModuleConfigurations, realmName, kernel, serverInfo, classLoader);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JaasLoginModuleUse.class, (String)"LoginModuleUse");
        infoBuilder.addAttribute("controlFlag", LoginModuleControlFlag.class, true);
        infoBuilder.addReference("LoginModule", LoginModuleSettings.class, "LoginModule");
        infoBuilder.addReference("Next", JaasLoginModuleUse.class);
        infoBuilder.addInterface(JaasLoginModuleChain.class);
        infoBuilder.setConstructor(new String[]{"LoginModule", "Next", "controlFlag"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

