/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.RealmPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappingLoginModule
implements LoginModule {
    public static final String CLASS_OPTION = WrappingLoginModule.class.getName() + ".LoginModuleClass";
    public static final String DOMAIN_OPTION = WrappingLoginModule.class.getName() + ".DomainName";
    public static final String REALM_OPTION = WrappingLoginModule.class.getName() + ".RealmName";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList(CLASS_OPTION, DOMAIN_OPTION, REALM_OPTION));
    private String loginDomainName;
    private String realmName;
    private final Subject localSubject = new Subject();
    private Subject subject;
    private LoginModule delegate;
    private final Set<Principal> wrapped = new HashSet<Principal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        Class lmClass = (Class)options.get(CLASS_OPTION);
        try {
            this.delegate = (LoginModule)lmClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create login module instance", e);
        }
        this.delegate.initialize(this.localSubject, callbackHandler, sharedState, options);
        this.loginDomainName = (String)options.get(DOMAIN_OPTION);
        this.realmName = (String)options.get(REALM_OPTION);
    }

    @Override
    public boolean login() throws LoginException {
        return this.delegate.login();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.delegate.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.delegate.commit();
        for (Principal principal : this.localSubject.getPrincipals()) {
            this.wrapped.add(new DomainPrincipal(this.loginDomainName, principal));
            this.wrapped.add(new RealmPrincipal(this.realmName, this.loginDomainName, principal));
        }
        this.subject.getPrincipals().addAll(this.wrapped);
        this.subject.getPrincipals().addAll(this.localSubject.getPrincipals());
        this.subject.getPrivateCredentials().addAll(this.localSubject.getPrivateCredentials());
        this.subject.getPublicCredentials().addAll(this.localSubject.getPublicCredentials());
        return result;
    }

    @Override
    public boolean logout() throws LoginException {
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.wrapped);
            this.subject.getPrincipals().removeAll(this.localSubject.getPrincipals());
            this.subject.getPrivateCredentials().removeAll(this.localSubject.getPrivateCredentials());
            this.subject.getPublicCredentials().removeAll(this.localSubject.getPublicCredentials());
            this.wrapped.clear();
        } else {
            this.wrapped.clear();
            this.localSubject.getPrincipals().clear();
            this.localSubject.setReadOnly();
        }
        return this.delegate.logout();
    }
}

