/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.xml.soap.SOAPMessage;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.ThreadData;

public class PolicyContextHandlerSOAPMessage
implements PolicyContextHandler {
    public static final String HANDLER_KEY = "javax.xml.soap.SOAPMessage";

    public boolean supports(String key) throws PolicyContextException {
        return HANDLER_KEY.equals(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{HANDLER_KEY};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (HANDLER_KEY.equals(key)) {
            return ((ThreadData)data).getSoapMessage();
        }
        return null;
    }

    public static SOAPMessage pushContextData(SOAPMessage SOAPMessage2) {
        ThreadData threadData = ContextManager.getThreadData();
        SOAPMessage oldMessage = threadData.getSoapMessage();
        threadData.setSoapMessage(SOAPMessage2);
        return oldMessage;
    }

    public static void popContextData(SOAPMessage oldMessage) {
        ThreadData threadData = ContextManager.getThreadData();
        threadData.setSoapMessage(oldMessage);
    }
}

