/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc.mappingprovider;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyConfigurationGeneric
implements GeronimoPolicyConfiguration {
    static final int OPEN = 1;
    static final int IN_SERVICE = 2;
    static final int DELETED = 3;
    private final String contextID;
    private int state;
    private final HashMap<String, Permissions> rolePermissionsMap = new HashMap();
    private final HashMap<Principal, Set<String>> principalRoleMapping = new HashMap();
    private Permissions unchecked = null;
    private Permissions excluded = null;
    private final HashMap<Principal, Permissions> principalPermissionsMap = new HashMap();

    PolicyConfigurationGeneric(String contextID) {
        this.contextID = contextID;
        this.state = 1;
    }

    public String getContextID() throws PolicyContextException {
        return this.contextID;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (this.unchecked != null && this.unchecked.implies(permission)) {
            return true;
        }
        Principal[] principals = domain.getPrincipals();
        if (principals.length == 0) {
            return false;
        }
        for (Principal principal : principals) {
            Permissions permissions = this.principalPermissionsMap.get(principal);
            if (permissions == null || !permissions.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPrincipalRoleMapping(Map<Principal, Set<String>> principalRoleMap) throws PolicyContextException {
        this.principalRoleMapping.clear();
        this.principalRoleMapping.putAll(principalRoleMap);
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.addToRole(roleName, e.nextElement());
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Permissions permissions = this.rolePermissionsMap.get(roleName);
        if (permissions == null) {
            permissions = new Permissions();
            this.rolePermissionsMap.put(roleName, permissions);
        }
        permissions.add(permission);
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.addToUncheckedPolicy(e.nextElement());
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        if (this.unchecked == null) {
            this.unchecked = new Permissions();
        }
        this.unchecked.add(permission);
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.addToExcludedPolicy(e.nextElement());
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        if (this.excluded == null) {
            this.excluded = new Permissions();
        }
        this.excluded.add(permission);
    }

    public void removeRole(String roleName) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.rolePermissionsMap.remove(roleName);
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.unchecked = null;
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.excluded = null;
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
    }

    public void delete() throws PolicyContextException {
        this.state = 3;
    }

    public void commit() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        for (Map.Entry<Principal, Set<String>> principalEntry : this.principalRoleMapping.entrySet()) {
            Principal principal = principalEntry.getKey();
            Permissions principalPermissions = this.principalPermissionsMap.get(principal);
            if (principalPermissions == null) {
                principalPermissions = new Permissions();
                this.principalPermissionsMap.put(principal, principalPermissions);
            }
            Set<String> roleSet = principalEntry.getValue();
            for (String role : roleSet) {
                Permissions permissions = this.rolePermissionsMap.get(role);
                if (permissions == null) continue;
                Enumeration<Permission> rolePermissions = permissions.elements();
                while (rolePermissions.hasMoreElements()) {
                    principalPermissions.add(rolePermissions.nextElement());
                }
            }
        }
        this.state = 2;
    }

    public boolean inService() throws PolicyContextException {
        return this.state == 2;
    }

    @Override
    public void open(boolean remove) {
        if (remove) {
            this.rolePermissionsMap.clear();
            this.principalRoleMapping.clear();
            this.unchecked = null;
            this.excluded = null;
            this.principalPermissionsMap.clear();
        }
        this.state = 1;
    }

    int getState() {
        return this.state;
    }
}

