/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.CertificateChainCallback;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateChainLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(CertificateChainLoginModule.class);
    public static final List<String> supportedOptions = Collections.unmodifiableList(Collections.EMPTY_LIST);
    private Subject subject;
    private CallbackHandler handler;
    private X500Principal principal;
    private boolean loginSucceeded;
    private final Set<Principal> allPrincipals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
    }

    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new CertificateChainCallback()};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        assert (callbacks.length == 1);
        Certificate[] certificateChain = ((CertificateChainCallback)callbacks[0]).getCertificateChain();
        if (certificateChain == null || certificateChain.length == 0) {
            throw new FailedLoginException();
        }
        if (!(certificateChain[0] instanceof X509Certificate)) {
            throw new FailedLoginException();
        }
        this.principal = ((X509Certificate)certificateChain[0]).getSubjectX500Principal();
        this.loginSucceeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            this.allPrincipals.add(this.principal);
            this.allPrincipals.add(new GeronimoUserPrincipal(this.principal.getName()));
            this.subject.getPrincipals().addAll(this.allPrincipals);
        }
        this.principal = null;
        return this.loginSucceeded;
    }

    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.principal = null;
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.principal = null;
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }
}

