/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(LDAPLoginModule.class);
    private Subject subject;
    private CallbackHandler handler;
    private static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    private static final String CONNECTION_URL = "connectionURL";
    private static final String CONNECTION_USERNAME = "connectionUsername";
    private static final String CONNECTION_PASSWORD = "connectionPassword";
    private static final String CONNECTION_PROTOCOL = "connectionProtocol";
    private static final String AUTHENTICATION = "authentication";
    private static final String USER_BASE = "userBase";
    private static final String USER_SEARCH_MATCHING = "userSearchMatching";
    private static final String USER_SEARCH_SUBTREE = "userSearchSubtree";
    private static final String ROLE_BASE = "roleBase";
    private static final String ROLE_NAME = "roleName";
    private static final String ROLE_SEARCH_MATCHING = "roleSearchMatching";
    private static final String ROLE_SEARCH_SUBTREE = "roleSearchSubtree";
    private static final String USER_ROLE_NAME = "userRoleName";
    private static final String FOLLOW_REFERRALS = "followReferrals";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("initialContextFactory", "connectionURL", "connectionUsername", "connectionPassword", "connectionProtocol", "authentication", "userBase", "userSearchMatching", "userSearchSubtree", "roleBase", "roleName", "roleSearchMatching", "roleSearchSubtree", "userRoleName", "followReferrals"));
    private String initialContextFactory;
    private String connectionURL;
    private String connectionUsername;
    private String connectionPassword;
    private String connectionProtocol;
    private String authentication;
    private String userBase;
    private String roleBase;
    private String roleName;
    private String userRoleName;
    private boolean followReferrals = true;
    private String cbUsername;
    private String cbPassword;
    protected DirContext context = null;
    private MessageFormat userSearchMatchingFormat;
    private MessageFormat roleSearchMatchingFormat;
    private boolean userSearchSubtreeBool = false;
    private boolean roleSearchSubtreeBool = false;
    private boolean loginSucceeded;
    private final Set<String> groups = new HashSet<String>();
    private final Set<Principal> allPrincipals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
        this.initialContextFactory = (String)options.get(INITIAL_CONTEXT_FACTORY);
        this.connectionURL = (String)options.get(CONNECTION_URL);
        this.connectionUsername = (String)options.get(CONNECTION_USERNAME);
        this.connectionPassword = (String)options.get(CONNECTION_PASSWORD);
        this.connectionProtocol = (String)options.get(CONNECTION_PROTOCOL);
        this.authentication = (String)options.get(AUTHENTICATION);
        this.userBase = (String)options.get(USER_BASE);
        String userSearchMatching = (String)options.get(USER_SEARCH_MATCHING);
        String userSearchSubtree = (String)options.get(USER_SEARCH_SUBTREE);
        this.roleBase = (String)options.get(ROLE_BASE);
        this.roleName = (String)options.get(ROLE_NAME);
        String roleSearchMatching = (String)options.get(ROLE_SEARCH_MATCHING);
        String roleSearchSubtree = (String)options.get(ROLE_SEARCH_SUBTREE);
        this.userRoleName = (String)options.get(USER_ROLE_NAME);
        this.userSearchMatchingFormat = new MessageFormat(userSearchMatching);
        this.roleSearchMatchingFormat = new MessageFormat(roleSearchMatching);
        this.userSearchSubtreeBool = Boolean.valueOf(userSearchSubtree);
        this.roleSearchSubtreeBool = Boolean.valueOf(roleSearchSubtree);
        String followReferralsStr = (String)options.get(FOLLOW_REFERRALS);
        this.followReferrals = followReferralsStr == null ? true : Boolean.valueOf(followReferralsStr);
    }

    @Override
    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.cbUsername = ((NameCallback)callbacks[0]).getName();
        this.cbPassword = new String(((PasswordCallback)callbacks[1]).getPassword());
        if (this.cbUsername == null || "".equals(this.cbUsername) || this.cbPassword == null || "".equals(this.cbPassword)) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            throw new FailedLoginException();
        }
        try {
            boolean result = this.authenticate(this.cbUsername, this.cbPassword);
            if (!result) {
                throw new FailedLoginException();
            }
        }
        catch (LoginException e) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            throw e;
        }
        catch (Exception e) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            throw (LoginException)new LoginException("LDAP Error").initCause(e);
        }
        this.loginSucceeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            if (this.cbUsername != null) {
                this.allPrincipals.add(new GeronimoUserPrincipal(this.cbUsername));
            }
            for (String group : this.groups) {
                this.allPrincipals.add(new GeronimoGroupPrincipal(group));
            }
            this.subject.getPrincipals().addAll(this.allPrincipals);
        }
        this.cbUsername = null;
        this.cbPassword = null;
        this.groups.clear();
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.cbUsername = null;
        this.cbPassword = null;
        this.groups.clear();
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }

    protected void close(DirContext context) {
        try {
            context.close();
        }
        catch (Exception e) {
            log.error("Failed to close context", (Throwable)e);
        }
    }

    protected boolean authenticate(String username, String password) throws Exception {
        DirContext context = this.open();
        try {
            String filter = this.userSearchMatchingFormat.format(new String[]{username});
            SearchControls constraints = new SearchControls();
            if (this.userSearchSubtreeBool) {
                constraints.setSearchScope(2);
            } else {
                constraints.setSearchScope(1);
            }
            String[] attribs = this.userRoleName == null ? new String[]{} : new String[]{this.userRoleName};
            constraints.setReturningAttributes(attribs);
            NamingEnumeration<SearchResult> results = context.search(this.userBase, filter, constraints);
            if (results == null || !results.hasMore()) {
                return false;
            }
            SearchResult result = results.next();
            if (results.hasMore()) {
                // empty if block
            }
            NameParser parser = context.getNameParser("");
            Name contextName = parser.parse(context.getNameInNamespace());
            Name baseName = parser.parse(this.userBase);
            Name entryName = parser.parse(result.getName());
            Name name = contextName.addAll(baseName);
            name = name.addAll(entryName);
            String dn = name.toString();
            Attributes attrs = result.getAttributes();
            if (attrs == null) {
                return false;
            }
            ArrayList<String> roles = null;
            if (this.userRoleName != null) {
                roles = this.addAttributeValues(this.userRoleName, attrs, roles);
            }
            this.bindUser(context, dn, password);
            roles = this.getRoles(context, dn, username, roles);
            for (String role : roles) {
                this.groups.add(role);
            }
        }
        catch (CommunicationException e) {
            this.close(context);
            throw (LoginException)new FailedLoginException().initCause(e);
        }
        catch (NamingException e) {
            this.close(context);
            throw (LoginException)new FailedLoginException().initCause(e);
        }
        return true;
    }

    protected ArrayList<String> getRoles(DirContext context, String dn, String username, ArrayList<String> list) throws NamingException {
        if (list == null) {
            list = new ArrayList();
        }
        if (this.roleName == null || "".equals(this.roleName)) {
            return list;
        }
        String filter = this.roleSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(dn), username});
        SearchControls constraints = new SearchControls();
        if (this.roleSearchSubtreeBool) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        constraints.setReturningAttributes(new String[]{this.roleName});
        NamingEnumeration<SearchResult> results = context.search(this.roleBase, filter, constraints);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) continue;
            list = this.addAttributeValues(this.roleName, attrs, list);
        }
        return list;
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected void bindUser(DirContext context, String dn, String password) throws NamingException, FailedLoginException {
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", password);
        try {
            context.getAttributes("", null);
        }
        catch (AuthenticationException e) {
            log.debug("Authentication failed for dn=" + dn);
            throw new FailedLoginException();
        }
        finally {
            if (this.connectionUsername != null) {
                context.addToEnvironment("java.naming.security.principal", this.connectionUsername);
            } else {
                context.removeFromEnvironment("java.naming.security.principal");
            }
            if (this.connectionPassword != null) {
                context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
            } else {
                context.removeFromEnvironment("java.naming.security.credentials");
            }
        }
    }

    private ArrayList<String> addAttributeValues(String attrId, Attributes attrs, ArrayList<String> values) throws NamingException {
        Attribute attr;
        if (attrId == null || attrs == null) {
            return values;
        }
        if (values == null) {
            values = new ArrayList();
        }
        if ((attr = attrs.get(attrId)) == null) {
            return values;
        }
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMore()) {
            String value = (String)e.next();
            values.add(value);
        }
        return values;
    }

    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            if (this.connectionUsername != null && this.connectionUsername.length() > 0) {
                env.put("java.naming.security.principal", this.connectionUsername);
            }
            if (this.connectionPassword != null && this.connectionPassword.length() > 0) {
                env.put("java.naming.security.credentials", this.connectionPassword);
            }
            env.put("java.naming.security.protocol", this.connectionProtocol == null ? "" : this.connectionProtocol);
            env.put("java.naming.provider.url", this.connectionURL == null ? "" : this.connectionURL);
            env.put("java.naming.security.authentication", this.authentication == null ? "" : this.authentication);
            env.put("java.naming.referral", this.followReferrals ? "follow" : "ignore");
            this.context = new InitialDirContext(env);
        }
        catch (NamingException e) {
            log.error("Failed to open context", (Throwable)e);
            throw e;
        }
        return this.context;
    }
}

