/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.sql.DataSource;
import org.apache.geronimo.crypto.encoders.Base64;
import org.apache.geronimo.crypto.encoders.HexTranslator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.management.geronimo.JCAManagedConnectionFactory;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(SQLLoginModule.class);
    public static final String USER_SELECT = "userSelect";
    public static final String GROUP_SELECT = "groupSelect";
    public static final String CONNECTION_URL = "jdbcURL";
    public static final String USER = "jdbcUser";
    public static final String PASSWORD = "jdbcPassword";
    public static final String DRIVER = "jdbcDriver";
    public static final String DATABASE_POOL_NAME = "dataSourceName";
    public static final String DATABASE_POOL_APP_NAME = "dataSourceApplication";
    public static final String DIGEST = "digest";
    public static final String ENCODING = "encoding";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("userSelect", "groupSelect", "jdbcURL", "jdbcUser", "jdbcPassword", "jdbcDriver", "dataSourceName", "dataSourceApplication", "digest", "encoding"));
    private String connectionURL;
    private Properties properties;
    private Driver driver;
    private JCAManagedConnectionFactory factory;
    private String userSelect;
    private String groupSelect;
    private String digest;
    private String encoding;
    private boolean loginSucceeded;
    private Subject subject;
    private CallbackHandler handler;
    private String cbUsername;
    private String cbPassword;
    private final Set<String> groups = new HashSet<String>();
    private final Set<Principal> allPrincipals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String dataSourceName;
        this.subject = subject;
        this.handler = callbackHandler;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
        this.userSelect = (String)options.get(USER_SELECT);
        this.groupSelect = (String)options.get(GROUP_SELECT);
        this.digest = (String)options.get(DIGEST);
        this.encoding = (String)options.get(ENCODING);
        if (this.digest != null && !this.digest.equals("")) {
            try {
                MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Initialization failed. Digest algorithm " + this.digest + " is not available.", (Throwable)e);
                throw new IllegalArgumentException("Unable to configure SQL login module: " + e.getMessage(), e);
            }
            if (this.encoding != null && !"hex".equalsIgnoreCase(this.encoding) && !"base64".equalsIgnoreCase(this.encoding)) {
                log.error("Initialization failed. Digest Encoding " + this.encoding + " is not supported.");
                throw new IllegalArgumentException("Unable to configure SQL login module. Digest Encoding " + this.encoding + " not supported.");
            }
        }
        if ((dataSourceName = (String)options.get(DATABASE_POOL_NAME)) != null) {
            dataSourceName = dataSourceName.trim();
            String dataSourceAppName = (String)options.get(DATABASE_POOL_APP_NAME);
            dataSourceAppName = dataSourceAppName == null || dataSourceAppName.trim().equals("") ? "null" : dataSourceAppName.trim();
            String kernelName = (String)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL");
            Kernel kernel = KernelRegistry.getKernel((String)kernelName);
            Set set = kernel.listGBeans(new AbstractNameQuery(JCAManagedConnectionFactory.class.getName()));
            for (AbstractName name : set) {
                if (!name.getName().get("J2EEApplication").equals(dataSourceAppName) || !name.getName().get("name").equals(dataSourceName)) continue;
                try {
                    JCAManagedConnectionFactory factory = (JCAManagedConnectionFactory)kernel.getGBean(name);
                    String type = factory.getConnectionFactoryInterface();
                    if (!type.equals(DataSource.class.getName())) continue;
                    this.factory = factory;
                    break;
                }
                catch (GBeanNotFoundException e) {
                }
            }
        } else {
            this.connectionURL = (String)options.get(CONNECTION_URL);
            this.properties = new Properties();
            if (options.get(USER) != null) {
                this.properties.put("user", options.get(USER));
            }
            if (options.get(PASSWORD) != null) {
                this.properties.put("password", options.get(PASSWORD));
            }
            ClassLoader cl = (ClassLoader)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER");
            try {
                this.driver = (Driver)cl.loadClass((String)options.get(DRIVER)).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Driver class " + options.get(DRIVER) + " is not available.  Perhaps you need to add it as a dependency in your deployment plan?", e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load, instantiate, register driver " + options.get(DRIVER) + ": " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        assert (callbacks.length == 2);
        this.cbUsername = ((NameCallback)callbacks[0]).getName();
        if (this.cbUsername == null || this.cbUsername.equals("")) {
            throw new FailedLoginException();
        }
        char[] provided = ((PasswordCallback)callbacks[1]).getPassword();
        this.cbPassword = provided == null ? null : new String(provided);
        try {
            Connection conn;
            if (this.factory != null) {
                DataSource ds = (DataSource)this.factory.getConnectionFactory();
                conn = ds.getConnection();
            } else {
                conn = this.driver.connect(this.connectionURL, this.properties);
            }
            try {
                int count;
                PreparedStatement statement = conn.prepareStatement(this.userSelect);
                try {
                    count = SQLLoginModule.countParameters(this.userSelect);
                    for (int i = 0; i < count; ++i) {
                        statement.setObject(i + 1, this.cbUsername);
                    }
                    ResultSet result = statement.executeQuery();
                    try {
                        boolean found = false;
                        while (result.next()) {
                            String userName = result.getString(1);
                            String userPassword = result.getString(2);
                            if (!this.cbUsername.equals(userName)) continue;
                            found = true;
                            if (this.checkPassword(userPassword, this.cbPassword)) break;
                            throw new FailedLoginException();
                        }
                        if (!found) {
                            throw new FailedLoginException();
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
                statement = conn.prepareStatement(this.groupSelect);
                try {
                    count = SQLLoginModule.countParameters(this.groupSelect);
                    for (int i = 0; i < count; ++i) {
                        statement.setObject(i + 1, this.cbUsername);
                    }
                    ResultSet result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            String userName = result.getString(1);
                            String groupName = result.getString(2);
                            if (!this.cbUsername.equals(userName)) continue;
                            this.groups.add(groupName);
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (LoginException e) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            throw e;
        }
        catch (SQLException sqle) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            throw (LoginException)new LoginException("SQL error").initCause(sqle);
        }
        catch (Exception e) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            throw (LoginException)new LoginException("Could not access datasource").initCause(e);
        }
        this.loginSucceeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            if (this.cbUsername != null) {
                this.allPrincipals.add(new GeronimoUserPrincipal(this.cbUsername));
            }
            for (String group : this.groups) {
                this.allPrincipals.add(new GeronimoGroupPrincipal(group));
            }
            this.subject.getPrincipals().addAll(this.allPrincipals);
        }
        this.cbUsername = null;
        this.cbPassword = null;
        this.groups.clear();
        return this.loginSucceeded;
    }

    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.cbUsername = null;
            this.cbPassword = null;
            this.groups.clear();
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.cbUsername = null;
        this.cbPassword = null;
        this.groups.clear();
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }

    private static int countParameters(String sql) {
        int count = 0;
        int pos = -1;
        while ((pos = sql.indexOf(63, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private boolean checkPassword(String real, String provided) {
        if (real == null && provided == null) {
            return true;
        }
        if (real == null || provided == null) {
            return false;
        }
        if (this.digest == null || this.digest.equals("")) {
            return real.equals(provided);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.digest);
            byte[] data = md.digest(provided.getBytes());
            if (this.encoding == null || "hex".equalsIgnoreCase(this.encoding)) {
                byte[] hexData = new byte[data.length * 2];
                HexTranslator ht = new HexTranslator();
                ht.encode(data, 0, data.length, hexData, 0);
                return real.equalsIgnoreCase(new String(hexData));
            }
            if ("base64".equalsIgnoreCase(this.encoding)) {
                return real.equals(new String(Base64.encode((byte[])data)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Should not occur.  Availability of algorithm has been checked at initialization.", (Throwable)e);
        }
        return false;
    }
}

