/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.credentialstore;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.credentialstore.CredentialStore;
import org.apache.geronimo.security.credentialstore.SingleCallbackHandler;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.GeronimoLoginConfiguration;

@GBean
public class SimpleCredentialStoreImpl
implements CredentialStore {
    private final Map<String, Map<String, Map<String, SingleCallbackHandler>>> credentialStore = new HashMap<String, Map<String, Map<String, SingleCallbackHandler>>>();
    private final Configuration configuration;

    public SimpleCredentialStoreImpl(@ParamAttribute(name="credentialStore") Map<String, Map<String, Map<String, String>>> credentials, @ParamReference(name="Realms", namingType="SecurityRealm") Collection<ConfigurationEntryFactory> realms, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader cl) {
        this.configuration = realms != null ? new GeronimoLoginConfiguration(realms, true) : null;
        if (credentials != null) {
            for (Map.Entry<String, Map<String, Map<String, String>>> realmData : credentials.entrySet()) {
                String realmName = realmData.getKey();
                Map<String, Map<String, SingleCallbackHandler>> realm = this.getRealm(realmName);
                for (Map.Entry<String, Map<String, String>> subjectData : realmData.getValue().entrySet()) {
                    String subjectId = subjectData.getKey();
                    Map<String, SingleCallbackHandler> subject = this.getSubject(realm, subjectId);
                    for (Map.Entry<String, String> credentialData : subjectData.getValue().entrySet()) {
                        String handlerType = credentialData.getKey();
                        String value = credentialData.getValue();
                        try {
                            Class<?> clazz = cl.loadClass(handlerType);
                            Constructor<?> c = clazz.getConstructor(String.class);
                            SingleCallbackHandler handler = (SingleCallbackHandler)c.newInstance(value);
                            String callbackType = handler.getCallbackType();
                            subject.put(callbackType, handler);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Could not construct SingleCallbackHandler of type: " + handlerType + " and value: " + value + " for subjectId: " + subjectId + " and realm: " + realmName, e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Subject getSubject(String realm, String id) throws LoginException {
        Map<String, Map<String, SingleCallbackHandler>> idMap = this.credentialStore.get(realm);
        if (idMap == null) {
            throw new LoginException("Unknown realm: " + realm);
        }
        final Map<String, SingleCallbackHandler> callbackInfos = idMap.get(id);
        if (callbackInfos == null) {
            throw new LoginException("Unknown id: " + id + " in realm: " + realm);
        }
        LoginContext loginContext = ContextManager.login(realm, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!callbackInfos.containsKey(callback.getClass().getName())) {
                        throw new UnsupportedCallbackException(callback);
                    }
                    SingleCallbackHandler singleCallbackHandler = (SingleCallbackHandler)callbackInfos.get(callback.getClass().getName());
                    singleCallbackHandler.handle(callback);
                }
            }
        }, this.configuration);
        return loginContext.getSubject();
    }

    public void addEntry(String realm, String id, Map<String, SingleCallbackHandler> callbackInfos) {
        Map<String, Map<String, SingleCallbackHandler>> idMap = this.getRealm(realm);
        idMap.put(id, callbackInfos);
    }

    private Map<String, Map<String, SingleCallbackHandler>> getRealm(String realm) {
        Map<String, Map<String, SingleCallbackHandler>> idMap = this.credentialStore.get(realm);
        if (idMap == null) {
            idMap = new HashMap<String, Map<String, SingleCallbackHandler>>();
            this.credentialStore.put(realm, idMap);
        }
        return idMap;
    }

    private Map<String, SingleCallbackHandler> getSubject(Map<String, Map<String, SingleCallbackHandler>> realm, String subjectId) {
        Map<String, SingleCallbackHandler> subject = realm.get(subjectId);
        if (subject == null) {
            subject = new HashMap<String, SingleCallbackHandler>();
            realm.put(subjectId, subject);
        }
        return subject;
    }
}

