/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc.mappingprovider;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.credentialstore.CredentialStore;
import org.apache.geronimo.security.deploy.SubjectInfo;
import org.apache.geronimo.security.jacc.PrincipalRoleMapper;
import org.apache.geronimo.security.jacc.mappingprovider.PrincipalRoleConfiguration;
import org.apache.geronimo.security.jacc.mappingprovider.PrincipalRoleConfigurationFactory;

public class ApplicationPrincipalRoleConfigurationManager
implements PrincipalRoleMapper {
    private static PrincipalRoleConfigurationFactory principalRoleConfigurationFactory;
    private final Map<Principal, Set<String>> principalRoleMap;
    private final Map<String, Subject> roleDesignates = new HashMap<String, Subject>();
    private final Subject defaultSubject;
    public static final GBeanInfo GBEAN_INFO;

    public ApplicationPrincipalRoleConfigurationManager(Map<Principal, Set<String>> principalRoleMap, SubjectInfo defaultSubjectInfo, Map<String, SubjectInfo> roleDesignates, CredentialStore credentialStore) throws PolicyContextException, ClassNotFoundException, LoginException {
        if (!(credentialStore != null || roleDesignates.isEmpty() && defaultSubjectInfo == null)) {
            throw new NullPointerException("No CredentialStore supplied to resolve default and run-as subjects");
        }
        this.principalRoleMap = principalRoleMap;
        if (defaultSubjectInfo == null) {
            this.defaultSubject = ContextManager.EMPTY;
        } else {
            this.defaultSubject = credentialStore.getSubject(defaultSubjectInfo.getRealm(), defaultSubjectInfo.getId());
            this.registerSubject(this.defaultSubject);
        }
        for (Map.Entry<String, SubjectInfo> entry : roleDesignates.entrySet()) {
            String role = entry.getKey();
            SubjectInfo subjectInfo = entry.getValue();
            if (subjectInfo == null || credentialStore == null) {
                throw new NullPointerException("No subjectInfo for role " + role);
            }
            Subject roleDesignate = credentialStore.getSubject(subjectInfo.getRealm(), subjectInfo.getId());
            this.registerSubject(roleDesignate);
            this.roleDesignates.put(role, roleDesignate);
        }
    }

    public static void setPrincipalRoleConfigurationFactory(PrincipalRoleConfigurationFactory principalRoleConfigurationFactory) {
        if (ApplicationPrincipalRoleConfigurationManager.principalRoleConfigurationFactory != null) {
            throw new IllegalStateException("ApplicationPrincipalRoleConfigurationManager.principalRoleConfigurationFactory already set");
        }
        ApplicationPrincipalRoleConfigurationManager.principalRoleConfigurationFactory = principalRoleConfigurationFactory;
    }

    @Override
    public void install(Set<String> contextIds) throws PolicyContextException {
        if (principalRoleConfigurationFactory == null) {
            throw new IllegalStateException("Inconsistent security setup.  PrincipalRoleConfigurationFactory is not set");
        }
        for (String contextID : contextIds) {
            PrincipalRoleConfiguration principalRoleConfiguration = principalRoleConfigurationFactory.getPrincipalRoleConfiguration(contextID);
            principalRoleConfiguration.setPrincipalRoleMapping(this.principalRoleMap);
        }
    }

    @Override
    public void uninstall(Set<String> contextIds) throws PolicyContextException {
    }

    private void registerSubject(Subject subject) {
        ContextManager.registerSubject(subject);
        SubjectId id = ContextManager.getSubjectId(subject);
        subject.getPrincipals().add(new IdentificationPrincipal(id));
    }

    @Override
    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    @Override
    public Subject getSubjectForRole(String role) {
        if (role == null) {
            return null;
        }
        Subject runAs = this.roleDesignates.get(role);
        if (runAs == null) {
            throw new IllegalStateException("no run-as identity configured for role: " + role);
        }
        return runAs;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        for (Map.Entry<String, Subject> entry : this.roleDesignates.entrySet()) {
            Subject roleDesignate = entry.getValue();
            ContextManager.unregisterSubject(roleDesignate);
        }
        if (this.defaultSubject != ContextManager.EMPTY) {
            ContextManager.unregisterSubject(this.defaultSubject);
        }
    }

    public void doFail() {
    }

    public GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ApplicationPrincipalRoleConfigurationManager.class, (String)"JACCManager");
        infoBuilder.addAttribute("principalRoleMap", Map.class, true);
        infoBuilder.addAttribute("defaultSubjectInfo", SubjectInfo.class, true);
        infoBuilder.addAttribute("roleDesignates", Map.class, true);
        infoBuilder.addReference("CredentialStore", CredentialStore.class, "GBean");
        infoBuilder.setConstructor(new String[]{"principalRoleMap", "defaultSubjectInfo", "roleDesignates", "CredentialStore"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

