/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.keystore;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.geronimo.crypto.KeystoreUtil;
import org.apache.geronimo.crypto.asn1.DERObjectIdentifier;
import org.apache.geronimo.crypto.asn1.x509.X509Name;
import org.apache.geronimo.crypto.jce.X509Principal;
import org.apache.geronimo.crypto.jce.X509V1CertificateGenerator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.util.InputUtils;
import org.apache.geronimo.management.geronimo.KeystoreException;
import org.apache.geronimo.management.geronimo.KeystoreInstance;
import org.apache.geronimo.management.geronimo.KeystoreIsLocked;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.security.keystore.FileKeystoreInstance;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKeystoreManager
implements KeystoreManager,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(FileKeystoreManager.class);
    private File directory;
    private ServerInfo serverInfo;
    private URI configuredDir;
    private Collection keystores;
    private Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public FileKeystoreManager(URI keystoreDir, ServerInfo serverInfo, Collection keystores, Kernel kernel) {
        this.configuredDir = keystoreDir;
        this.serverInfo = serverInfo;
        this.keystores = keystores;
        this.kernel = kernel;
    }

    public void doStart() throws Exception {
        URI rootURI = this.serverInfo != null ? this.serverInfo.resolveServer(this.configuredDir) : this.configuredDir;
        if (!rootURI.getScheme().equals("file")) {
            throw new IllegalStateException("FileKeystoreManager must have a root that's a local directory (not " + rootURI + ")");
        }
        this.directory = new File(rootURI);
        if (!this.directory.exists() && this.directory.mkdirs()) {
            log.warn("The keystore directory: " + this.directory.getAbsolutePath() + " does not exist. System automatically created one.");
        }
        if (!(this.directory.exists() && this.directory.isDirectory() && this.directory.canRead())) {
            throw new IllegalStateException("FileKeystoreManager must have a root that's a valid readable directory (not " + this.directory.getAbsolutePath() + ")");
        }
        log.debug("Keystore directory is " + this.directory.getAbsolutePath());
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public void initializeKeystores() {
        this.getKeystores();
    }

    public String[] listKeystoreFiles() {
        File[] files = this.directory.listFiles();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.canRead() || file.isDirectory()) continue;
            String name = file.getName();
            if (name.lastIndexOf(".") == -1) {
                list.add(file.getName());
                continue;
            }
            String type = name.substring(name.lastIndexOf(".") + 1);
            if (file.length() > 0L) {
                for (String ktype : KeystoreUtil.keystoreTypes) {
                    if (!ktype.toLowerCase().equals(type.toLowerCase())) continue;
                    list.add(file.getName());
                }
                continue;
            }
            if (file.length() != 0L) continue;
            for (String ktype : KeystoreUtil.emptyKeystoreTypes) {
                if (!ktype.toLowerCase().equals(type.toLowerCase())) continue;
                list.add(file.getName());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public KeystoreInstance[] getKeystores() {
        String[] names = this.listKeystoreFiles();
        KeystoreInstance[] result = new KeystoreInstance[names.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getKeystore(names[i], null);
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    public KeystoreInstance getKeystore(String name, String type) {
        for (KeystoreInstance instance : this.keystores) {
            if (!instance.getKeystoreName().equals(name)) continue;
            return instance;
        }
        File test = new File(this.directory, name);
        if (!test.exists() || !test.canRead()) {
            throw new IllegalArgumentException("Cannot access keystore " + test.getAbsolutePath() + "!");
        }
        AbstractName myName = this.kernel.getAbstractNameFor((Object)this);
        AbstractName aName = this.kernel.getNaming().createSiblingName(myName, name, "Keystore");
        GBeanData data = new GBeanData(aName, FileKeystoreInstance.getGBeanInfo());
        try {
            String path = this.configuredDir.toString();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            data.setAttribute("keystorePath", (Object)new URI(path + name));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can't resolve keystore path: " + e.getMessage(), e);
        }
        data.setReferencePattern("ServerInfo", this.kernel.getAbstractNameFor((Object)this.serverInfo));
        data.setAttribute("keystoreName", (Object)name);
        if (type == null) {
            if (name.lastIndexOf(".") == -1) {
                type = KeystoreUtil.defaultType;
                log.warn("keystoreType for new keystore \"" + name + "\" set to default type \"" + type + "\".");
            } else {
                type = name.substring(name.lastIndexOf(".") + 1);
                log.warn("keystoreType for new keystore \"" + name + "\" set to \"" + type + "\" based on file extension.");
            }
        }
        data.setAttribute("keystoreType", (Object)type);
        EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
        if (mgr != null) {
            try {
                mgr.addGBeanToConfiguration(myName.getArtifact(), data, true);
                KeystoreInstance keystoreInstance = (KeystoreInstance)this.kernel.getProxyManager().createProxy(aName, KeystoreInstance.class);
                return keystoreInstance;
            }
            catch (InvalidConfigException e) {
                log.error("Should never happen", (Throwable)e);
                throw new IllegalStateException("Unable to add Keystore GBean (" + e.getMessage() + ")", e);
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        }
        log.warn("The ConfigurationManager in the kernel does not allow changes at runtime");
        return null;
    }

    public SSLSocketFactory createSSLFactory(String provider, String protocol, String algorithm, String trustStore, ClassLoader loader) throws KeystoreException {
        return this.createSSLFactory(provider, protocol, algorithm, null, null, trustStore, loader);
    }

    public SSLSocketFactory createSSLFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore, ClassLoader loader) throws KeystoreException {
        KeystoreInstance trustInstance;
        KeystoreInstance keyInstance = null;
        if (keyStore != null) {
            keyInstance = this.getKeystore(keyStore, null);
            if (keyInstance.isKeystoreLocked()) {
                throw new KeystoreIsLocked("Keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
            }
            if (keyInstance.isKeyLocked(keyAlias)) {
                throw new KeystoreIsLocked("Key '" + keyAlias + "' in keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
            }
        }
        KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore, null);
        if (trustInstance != null && trustInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + trustStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        try {
            Class<?> cls = loader.loadClass("javax.net.ssl.SSLContext");
            Object ctx = cls.getMethod("getInstance", String.class).invoke(null, protocol);
            Class<?> kmc = Class.forName("[Ljavax.net.ssl.KeyManager;", false, loader);
            Class<?> tmc = Class.forName("[Ljavax.net.ssl.TrustManager;", false, loader);
            Class<?> src = loader.loadClass("java.security.SecureRandom");
            cls.getMethod("init", kmc, tmc, src).invoke(ctx, keyInstance == null ? null : keyInstance.getKeyManager(algorithm, keyAlias, null), trustInstance == null ? null : trustInstance.getTrustManager(algorithm, null), new SecureRandom());
            Object result = cls.getMethod("getSocketFactory", new Class[0]).invoke(ctx, new Object[0]);
            return (SSLSocketFactory)result;
        }
        catch (Exception e) {
            throw new KeystoreException("Unable to create SSL Factory", (Throwable)e);
        }
    }

    public SSLServerSocketFactory createSSLServerFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore, ClassLoader loader) throws KeystoreException {
        SSLContext sslContext = this.createSSLContext(provider, protocol, algorithm, keyStore, keyAlias, trustStore, loader);
        try {
            Object result = sslContext.getClass().getMethod("getServerSocketFactory", new Class[0]).invoke((Object)sslContext, new Object[0]);
            return (SSLServerSocketFactory)result;
        }
        catch (Exception e) {
            throw new KeystoreException("Unable to create SSL Server Factory", (Throwable)e);
        }
    }

    public SSLContext createSSLContext(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore, ClassLoader loader) throws KeystoreException {
        KeystoreInstance trustInstance;
        KeystoreInstance keyInstance = this.getKeystore(keyStore, null);
        if (keyInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        if (keyInstance.isKeyLocked(keyAlias)) {
            throw new KeystoreIsLocked("Key '" + keyAlias + "' in keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore, null);
        if (trustInstance != null && trustInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + trustStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        try {
            Class<?> cls = loader.loadClass("javax.net.ssl.SSLContext");
            Object ctx = cls.getMethod("getInstance", String.class).invoke(null, protocol);
            Class<?> kmc = Class.forName("[Ljavax.net.ssl.KeyManager;", false, loader);
            Class<?> tmc = Class.forName("[Ljavax.net.ssl.TrustManager;", false, loader);
            Class<?> src = loader.loadClass("java.security.SecureRandom");
            cls.getMethod("init", kmc, tmc, src).invoke(ctx, keyInstance.getKeyManager(algorithm, keyAlias, null), trustInstance == null ? null : trustInstance.getTrustManager(algorithm, null), new SecureRandom());
            return (SSLContext)ctx;
        }
        catch (Exception e) {
            throw new KeystoreException("Unable to create SSL Context", (Throwable)e);
        }
    }

    public KeystoreInstance createKeystore(String name, char[] password, String keystoreType) throws KeystoreException {
        InputUtils.validateSafeInput((String)name);
        File test = new File(this.directory, name);
        if (test.exists()) {
            throw new IllegalArgumentException("Keystore already exists " + test.getAbsolutePath() + "!");
        }
        try {
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            keystore.load(null, password);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(test));
            keystore.store(out, password);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            return this.getKeystore(name, keystoreType);
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to create keystore", (Throwable)e);
        }
        catch (IOException e) {
            throw new KeystoreException("Unable to create keystore", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to create keystore", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new KeystoreException("Unable to create keystore", (Throwable)e);
        }
    }

    public KeystoreInstance[] getUnlockedKeyStores() {
        ArrayList<KeystoreInstance> results = new ArrayList<KeystoreInstance>();
        for (KeystoreInstance instance : this.keystores) {
            try {
                if (instance.isKeystoreLocked() || instance.getUnlockedKeys(null).length <= 0) continue;
                results.add(instance);
            }
            catch (KeystoreException e) {}
        }
        return results.toArray(new KeystoreInstance[results.size()]);
    }

    public KeystoreInstance[] getUnlockedTrustStores() {
        ArrayList<KeystoreInstance> results = new ArrayList<KeystoreInstance>();
        for (KeystoreInstance instance : this.keystores) {
            try {
                if (instance.isKeystoreLocked() || !instance.isTrustStore(null)) continue;
                results.add(instance);
            }
            catch (KeystoreException e) {}
        }
        return results.toArray(new KeystoreInstance[results.size()]);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public X509Certificate generateCert(PublicKey publicKey, PrivateKey privateKey, String sigalg, int validity, String cn, String ou, String o, String l, String st, String c) throws SignatureException, InvalidKeyException {
        X509V1CertificateGenerator certgen = new X509V1CertificateGenerator();
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, String> attrmap = new Hashtable<DERObjectIdentifier, String>();
        if (cn != null) {
            attrmap.put(X509Principal.CN, cn);
            order.add(X509Principal.CN);
        }
        if (ou != null) {
            attrmap.put(X509Principal.OU, ou);
            order.add(X509Principal.OU);
        }
        if (o != null) {
            attrmap.put(X509Principal.O, o);
            order.add(X509Principal.O);
        }
        if (l != null) {
            attrmap.put(X509Principal.L, l);
            order.add(X509Principal.L);
        }
        if (st != null) {
            attrmap.put(X509Principal.ST, st);
            order.add(X509Principal.ST);
        }
        if (c != null) {
            attrmap.put(X509Principal.C, c);
            order.add(X509Principal.C);
        }
        X509Principal issuerDN = new X509Principal(order, attrmap);
        certgen.setIssuerDN((X509Name)issuerDN);
        long curr = System.currentTimeMillis();
        long untill = curr + (long)validity * 24L * 60L * 60L * 1000L;
        certgen.setNotBefore(new Date(curr));
        certgen.setNotAfter(new Date(untill));
        certgen.setSubjectDN((X509Name)issuerDN);
        certgen.setPublicKey(publicKey);
        certgen.setSignatureAlgorithm(sigalg);
        certgen.setSerialNumber(new BigInteger(String.valueOf(curr)));
        return certgen.generateX509Certificate(privateKey);
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(FileKeystoreManager.class);
        infoFactory.addAttribute("keystoreDir", URI.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("KeystoreInstances", KeystoreInstance.class, "Keystore");
        infoFactory.addInterface(KeystoreManager.class);
        infoFactory.setConstructor(new String[]{"keystoreDir", "ServerInfo", "KeystoreInstances", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

