/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;

public class ConstantLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler handler;
    private String userName;
    private String groupNames;
    private static final String USER_NAME = "userName";
    private static final String GROUP_NAMES = "groupNames";

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.userName != null) {
            this.subject.getPrincipals().add(new GeronimoUserPrincipal(this.userName));
        }
        if (this.groupNames != null) {
            for (String groupName : this.groupNames.split(",")) {
                this.subject.getPrincipals().add(new GeronimoGroupPrincipal(groupName));
            }
        }
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.userName = (String)options.get(USER_NAME);
        this.groupNames = (String)options.get(GROUP_NAMES);
    }

    @Override
    public boolean login() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

