/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoPasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoPasswordCredentialLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(GeronimoPasswordCredentialLoginModule.class);
    public static final List<String> supportedOptions = Collections.unmodifiableList(Collections.EMPTY_LIST);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private GeronimoPasswordCredential geronimoPasswordCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("name"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw (LoginException)new LoginException("Could not determine username and password").initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException("Unlikely UnsupportedCallbackException").initCause(e);
        }
        String username = ((NameCallback)callbacks[0]).getName();
        char[] password = ((PasswordCallback)callbacks[1]).getPassword();
        if (username == null || password == null) {
            return false;
        }
        this.geronimoPasswordCredential = new GeronimoPasswordCredential(username, password);
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.geronimoPasswordCredential != null) {
            this.subject.getPrivateCredentials().add(this.geronimoPasswordCredential);
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.geronimoPasswordCredential != null) {
            try {
                this.geronimoPasswordCredential.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            this.geronimoPasswordCredential = null;
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.geronimoPasswordCredential == null) {
            return false;
        }
        if (!this.subject.isReadOnly()) {
            this.subject.getPrivateCredentials().remove(this.geronimoPasswordCredential);
        }
        try {
            this.geronimoPasswordCredential.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        this.geronimoPasswordCredential = null;
        return false;
    }
}

