/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.condition.ConditionParser;
import org.apache.geronimo.system.configuration.condition.JexlConditionParser;
import org.apache.geronimo.system.configuration.condition.JexlExpressionParser;
import org.apache.geronimo.system.plugin.model.GbeanType;
import org.apache.geronimo.system.plugin.model.ModuleType;

class ConfigurationOverride {
    private static final ConditionParser DEFAULT_COND_PARSER = new JexlConditionParser();
    private final Artifact name;
    private boolean load;
    private String condition;
    private String comment;
    private final Map<Object, GBeanOverride> gbeans = new LinkedHashMap<Object, GBeanOverride>();
    private ConditionParser parser = DEFAULT_COND_PARSER;

    public ConfigurationOverride(Artifact name, boolean load) {
        this.name = name;
        this.load = load;
    }

    public ConfigurationOverride(ConfigurationOverride base, Artifact name) {
        this.name = name;
        this.load = base.load;
        this.condition = base.condition;
        this.comment = base.comment;
        for (GBeanOverride gbean : base.gbeans.values()) {
            GBeanOverride replacement = new GBeanOverride(gbean, base.name.toString(), name.toString());
            this.gbeans.put(replacement.getName(), replacement);
        }
    }

    public ConfigurationOverride(ModuleType module, JexlExpressionParser expressionParser) throws InvalidGBeanException {
        this.name = Artifact.create((String)module.getName());
        this.condition = module.getCondition();
        this.comment = module.getComment();
        this.load = module.isLoad();
        for (GbeanType gbeanType : module.getGbean()) {
            GBeanOverride gbean = new GBeanOverride(gbeanType, expressionParser);
            this.addGBean(gbean);
        }
        this.parser = new JexlConditionParser(expressionParser.getVariables());
    }

    public Artifact getName() {
        return this.name;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private boolean parseCondition() {
        if (this.condition == null) {
            return true;
        }
        return this.parser.evaluate(this.condition);
    }

    public boolean isLoad() {
        return this.load && this.parseCondition();
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public GBeanOverride getGBean(String gbeanName) {
        return this.gbeans.get(gbeanName);
    }

    public void addGBean(GBeanOverride gbean) {
        this.gbeans.put(gbean.getName(), gbean);
    }

    public void addGBean(String gbeanName, GBeanOverride gbean) {
        this.gbeans.put(gbeanName, gbean);
    }

    public Map getGBeans() {
        return this.gbeans;
    }

    public GBeanOverride getGBean(AbstractName gbeanName) {
        return this.gbeans.get(gbeanName);
    }

    public void addGBean(AbstractName gbeanName, GBeanOverride gbean) {
        this.gbeans.put(gbeanName, gbean);
    }

    public ModuleType writeXml() {
        ModuleType module = new ModuleType();
        module.setName(this.name.toString());
        if (this.condition != null && this.condition.trim().length() != 0) {
            module.setCondition(this.condition);
        } else if (!this.load) {
            module.setLoad(false);
        }
        if (this.comment != null && this.comment.trim().length() > 0) {
            module.setComment(this.comment.trim());
        }
        for (GBeanOverride gbeanOverride : this.gbeans.values()) {
            GbeanType gbean = gbeanOverride.writeXml();
            module.getGbean().add(gbean);
        }
        return module;
    }
}

