/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.logging.SystemLog;
import org.apache.geronimo.system.logging.log4j.URLConfigurator;
import org.apache.geronimo.system.properties.JvmVendor;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4jService
implements GBeanLifecycle,
SystemLog {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{.*?\\}");
    private static final Pattern DEFAULT_ANY_START = Pattern.compile("^\\d\\d\\:\\d\\d\\:\\d\\d\\,\\d\\d\\d (TRACE|DEBUG|INFO|WARN|ERROR|FATAL) .*");
    private static final Pattern DEFAULT_FATAL_START = Pattern.compile("^\\d\\d\\:\\d\\d\\:\\d\\d\\,\\d\\d\\d FATAL .*");
    private static final Pattern DEFAULT_ERROR_START = Pattern.compile("^\\d\\d\\:\\d\\d\\:\\d\\d\\,\\d\\d\\d (ERROR|FATAL) .*");
    private static final Pattern DEFAULT_WARN_START = Pattern.compile("^\\d\\d\\:\\d\\d\\:\\d\\d\\,\\d\\d\\d (WARN|ERROR|FATAL) .*");
    private static final Pattern DEFAULT_INFO_START = Pattern.compile("^\\d\\d\\:\\d\\d\\:\\d\\d\\,\\d\\d\\d (INFO|WARN|ERROR|FATAL) .*");
    private static final Pattern DEFAULT_DEBUG_START = Pattern.compile("^\\d\\d\\:\\d\\d\\:\\d\\d\\,\\d\\d\\d (DEBUG|INFO|WARN|ERROR|FATAL) .*");
    private static final Pattern UNKNOWN_ANY_START = Pattern.compile("(TRACE|DEBUG|INFO|WARN|ERROR|FATAL)");
    private static final Pattern UNKNOWN_FATAL_START = Pattern.compile("FATAL");
    private static final Pattern UNKNOWN_ERROR_START = Pattern.compile("(ERROR|FATAL)");
    private static final Pattern UNKNOWN_WARN_START = Pattern.compile("(WARN|ERROR|FATAL)");
    private static final Pattern UNKNOWN_INFO_START = Pattern.compile("(INFO|WARN|ERROR|FATAL)");
    private static final Pattern UNKNOWN_DEBUG_START = Pattern.compile("(DEBUG|INFO|WARN|ERROR|FATAL)");
    private static final Logger log = LoggerFactory.getLogger(Log4jService.class);
    private static final String LOG4JSERVICE_CONFIG_PROPERTY = "org.apache.geronimo.log4jservice.configuration";
    private String configurationFile;
    private int refreshPeriod;
    private final ServerInfo serverInfo;
    private Timer timer = new Timer(true);
    private TimerTask monitor;
    private long lastChanged = -1L;
    private boolean running = false;
    public static final GBeanInfo GBEAN_INFO;

    public Log4jService(String configurationFile, int refreshPeriod, ServerInfo serverInfo) {
        this.refreshPeriod = refreshPeriod;
        this.configurationFile = configurationFile;
        this.serverInfo = serverInfo;
        org.apache.log4j.Logger.getLogger((String)this.getClass().getName()).setLevel(Level.INFO);
    }

    public synchronized String getRootLoggerLevel() {
        Level level = LogManager.getRootLogger().getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public synchronized void setRootLoggerLevel(String level) {
        String currentLevel = this.getRootLoggerLevel();
        if (!currentLevel.equals(level)) {
            LogManager.getRootLogger().setLevel(Level.toLevel((String)level));
        }
    }

    public String getLoggerEffectiveLevel(String logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        Level level = LogManager.getLogger((String)logger).getEffectiveLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public String getLoggerLevel(String logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        Level level = LogManager.getLogger((String)logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public void setLoggerLevel(String logger, String level) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level is null");
        }
        log.info("Setting logger level: logger=" + logger + ", level=" + level);
        org.apache.log4j.Logger.getLogger((String)logger).setLevel(Level.toLevel((String)level));
    }

    public synchronized int getRefreshPeriodSeconds() {
        return this.refreshPeriod;
    }

    public synchronized void setRefreshPeriodSeconds(int period) {
        if (period < 5) {
            throw new IllegalArgumentException("Refresh period must be at least 5 seconds");
        }
        if (this.refreshPeriod != period) {
            this.refreshPeriod = period;
            this.schedule();
        }
    }

    public synchronized String getConfigFileName() {
        return this.configurationFile;
    }

    public synchronized void setConfigFileName(String configurationFile) {
        if (configurationFile == null) {
            throw new IllegalArgumentException("configurationFile is null");
        }
        log.debug("Using configuration file: {}", (Object)configurationFile);
        if (!this.configurationFile.equals(configurationFile)) {
            this.configurationFile = configurationFile;
            this.lastChanged = -1L;
            this.reconfigure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getConfiguration() {
        File file = this.resolveConfigurationFile();
        if (file == null || !file.canRead()) {
            return null;
        }
        Reader in = null;
        try {
            StringBuffer configuration = new StringBuffer();
            in = new InputStreamReader(new FileInputStream(file));
            char[] buffer = new char[4096];
            int size = in.read(buffer);
            while (size >= 0) {
                configuration.append(buffer, 0, size);
                size = in.read(buffer);
            }
            String string = configuration.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConfiguration(String configuration) throws IOException {
        if (configuration == null || configuration.length() == 0) {
            throw new IllegalArgumentException("configuration is null or an empty string");
        }
        File file = this.resolveConfigurationFile();
        if (file == null) {
            throw new IllegalStateException("Configuration file is null");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create parent directory of log configuration file: " + file.getParent());
        }
        if (file.exists() && !file.canWrite()) {
            throw new IllegalStateException("Configuration file is not writable: " + file.getAbsolutePath());
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(configuration.getBytes());
            log.info("Updated configuration file: {}", (Object)file);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized String[] getLogFileNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Object appender = e.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            list.add(((FileAppender)appender).getFile());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SystemLog.SearchResults searchFile(File file, String targetLevel, Pattern textSearch, Integer start, Integer stop, int max, boolean stacks) {
        LinkedList<SystemLog.LogMessage> list = new LinkedList<SystemLog.LogMessage>();
        boolean capped = false;
        int lineCount = 0;
        FileInputStream logInputStream = null;
        try {
            String line;
            logInputStream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)logInputStream, System.getProperty("file.encoding")));
            Matcher target = null;
            Matcher any = null;
            Matcher text = textSearch == null ? null : textSearch.matcher("");
            boolean hit = false;
            max = Math.min(max, 1000);
            while ((line = reader.readLine()) != null) {
                ++lineCount;
                if (target == null) {
                    if (DEFAULT_ANY_START.matcher(line).find()) {
                        target = Log4jService.getDefaultPatternForLevel(targetLevel).matcher("");
                        any = DEFAULT_ANY_START.matcher("");
                    } else {
                        target = Log4jService.getUnknownPatternForLevel(targetLevel).matcher("");
                        any = UNKNOWN_ANY_START.matcher("");
                    }
                }
                if (start != null && start > lineCount || stop != null && stop < lineCount) continue;
                target.reset(line);
                if (target.find()) {
                    if (text != null) {
                        text.reset(line);
                        if (!text.find()) {
                            hit = false;
                            continue;
                        }
                    }
                    list.add(new SystemLog.LogMessage(lineCount, line.toString()));
                    if (list.size() > max) {
                        list.remove(0);
                        capped = true;
                    }
                    hit = true;
                    continue;
                }
                if (!stacks || !hit) continue;
                any.reset(line);
                if (!any.find()) {
                    list.add(new SystemLog.LogMessage(lineCount, line.toString()));
                    if (list.size() <= max) continue;
                    list.remove(0);
                    capped = true;
                    continue;
                }
                hit = false;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (logInputStream != null) {
                try {
                    logInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return new SystemLog.SearchResults(lineCount, list.toArray(new SystemLog.LogMessage[list.size()]), capped);
    }

    private static String substituteSystemProps(String source) {
        StringBuffer buf = new StringBuffer();
        int last = 0;
        Matcher m = VARIABLE_PATTERN.matcher(source);
        while (m.find()) {
            buf.append(source.substring(last, m.start()));
            String prop = source.substring(m.start() + 2, m.end() - 1);
            buf.append(System.getProperty(prop));
            last = m.end();
        }
        buf.append(source.substring(last));
        return buf.toString();
    }

    private static Pattern getDefaultPatternForLevel(String targetLevel) {
        if (targetLevel.equals("FATAL")) {
            return DEFAULT_FATAL_START;
        }
        if (targetLevel.equals("ERROR")) {
            return DEFAULT_ERROR_START;
        }
        if (targetLevel.equals("WARN")) {
            return DEFAULT_WARN_START;
        }
        if (targetLevel.equals("INFO")) {
            return DEFAULT_INFO_START;
        }
        if (targetLevel.equals("DEBUG")) {
            return DEFAULT_DEBUG_START;
        }
        return DEFAULT_ANY_START;
    }

    private static Pattern getUnknownPatternForLevel(String targetLevel) {
        if (targetLevel.equals("FATAL")) {
            return UNKNOWN_FATAL_START;
        }
        if (targetLevel.equals("ERROR")) {
            return UNKNOWN_ERROR_START;
        }
        if (targetLevel.equals("WARN")) {
            return UNKNOWN_WARN_START;
        }
        if (targetLevel.equals("INFO")) {
            return UNKNOWN_INFO_START;
        }
        if (targetLevel.equals("DEBUG")) {
            return UNKNOWN_DEBUG_START;
        }
        return UNKNOWN_ANY_START;
    }

    public SystemLog.SearchResults getMatchingItems(String logFile, Integer firstLine, Integer lastLine, String minLevel, String text, int maxResults, boolean includeStackTraces) {
        if (logFile == null) {
            throw new IllegalArgumentException("Must specify a log file");
        }
        String[] files = this.getLogFileNames();
        boolean found = false;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(logFile)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Not a log file!");
        }
        if (minLevel == null) {
            minLevel = "TRACE";
        } else if (!(minLevel.equals("FATAL") || minLevel.equals("ERROR") || minLevel.equals("WARN") || minLevel.equals("INFO") || minLevel.equals("DEBUG") || minLevel.equals("TRACE"))) {
            throw new IllegalArgumentException("Not a valid log level");
        }
        Pattern textPattern = null;
        try {
            textPattern = text == null || text.equals("") ? null : Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Bad regular expression '" + text + "'", e);
        }
        File file = new File(Log4jService.substituteSystemProps(logFile));
        if (!file.exists()) {
            throw new IllegalArgumentException("Log file " + file.getAbsolutePath() + " does not exist");
        }
        return Log4jService.searchFile(file, minLevel, textPattern, firstLine, lastLine, maxResults, includeStackTraces);
    }

    public void reconfigure() {
        File file = this.resolveConfigurationFile();
        if (file == null || !file.exists()) {
            return;
        }
        log.debug("Reconfiguring from: {}", (Object)this.configurationFile);
        this.lastChanged = file.lastModified();
        try {
            URLConfigurator.configure(file.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private synchronized void schedule() {
        if (this.timer != null) {
            if (this.monitor != null) {
                this.monitor.cancel();
            }
            TimerTask task = this.monitor = new URLMonitorTask();
            this.timer.schedule(this.monitor, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        String cfgFile = System.getProperty(LOG4JSERVICE_CONFIG_PROPERTY);
        if (cfgFile != null && !cfgFile.equals("")) {
            this.configurationFile = cfgFile;
        }
        Log4jService log4jService = this;
        synchronized (log4jService) {
            this.reconfigure();
            this.timer = new Timer(true);
            this.schedule();
        }
        this.logEnvInfo();
        log4jService = this;
        synchronized (log4jService) {
            this.running = true;
        }
    }

    public synchronized void doStop() {
        this.running = false;
        if (this.monitor != null) {
            this.monitor.cancel();
            this.monitor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        log.info("Stopping Logging Service");
        log.info("----------------------------------------------");
        LogManager.shutdown();
    }

    public void doFail() {
        this.doStop();
    }

    private synchronized File resolveConfigurationFile() {
        try {
            return this.serverInfo.resolveServer(this.configurationFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void logEnvInfo() {
        try {
            log.info("----------------------------------------------");
            log.info("Started Logging Service");
            log.debug("Log4jService created with configFileName={}, refreshPeriodSeconds={}", (Object)this.configurationFile, (Object)this.refreshPeriod);
            log.info("Runtime Information:");
            log.info("  Install Directory = " + DirectoryUtils.getGeronimoInstallDirectory());
            log.info("  JVM in use        = " + JvmVendor.getJvmInfo());
            log.info("Java Information:");
            log.info("  System property [java.runtime.name]     = " + System.getProperty("java.runtime.name"));
            log.info("  System property [java.runtime.version]  = " + System.getProperty("java.runtime.version"));
            log.info("  System property [os.name]               = " + System.getProperty("os.name"));
            log.info("  System property [os.version]            = " + System.getProperty("os.version"));
            log.info("  System property [sun.os.patch.level]    = " + System.getProperty("sun.os.patch.level"));
            log.info("  System property [os.arch]               = " + System.getProperty("os.arch"));
            log.info("  System property [java.class.version]    = " + System.getProperty("java.class.version"));
            log.info("  System property [locale]                = " + System.getProperty("user.language") + "_" + System.getProperty("user.country"));
            log.info("  System property [unicode.encoding]      = " + System.getProperty("sun.io.unicode.encoding"));
            log.info("  System property [file.encoding]         = " + System.getProperty("file.encoding"));
            log.info("  System property [java.vm.name]          = " + System.getProperty("java.vm.name"));
            log.info("  System property [java.vm.vendor]        = " + System.getProperty("java.vm.vendor"));
            log.info("  System property [java.vm.version]       = " + System.getProperty("java.vm.version"));
            log.info("  System property [java.vm.info]          = " + System.getProperty("java.vm.info"));
            log.info("  System property [java.home]             = " + System.getProperty("java.home"));
            log.info("  System property [java.classpath]        = " + System.getProperty("java.classpath"));
            log.info("  System property [java.library.path]     = " + System.getProperty("java.library.path"));
            log.info("  System property [java.endorsed.dirs]    = " + System.getProperty("java.endorsed.dirs"));
            log.info("  System property [java.ext.dirs]         = " + System.getProperty("java.ext.dirs"));
            log.info("  System property [sun.boot.class.path]   = " + System.getProperty("sun.boot.class.path"));
            log.info("----------------------------------------------");
        }
        catch (Exception e) {
            System.err.println("Exception caught during logging of Runtime Information.  Exception=" + e.toString());
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(Log4jService.class, (String)"SystemLog");
        infoFactory.addAttribute("configFileName", String.class, true);
        infoFactory.addAttribute("refreshPeriodSeconds", Integer.TYPE, true);
        infoFactory.addAttribute("configuration", String.class, false);
        infoFactory.addAttribute("rootLoggerLevel", String.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addOperation("reconfigure");
        infoFactory.addOperation("setLoggerLevel", new Class[]{String.class, String.class});
        infoFactory.addOperation("getLoggerLevel", new Class[]{String.class});
        infoFactory.addOperation("getLoggerEffectiveLevel", new Class[]{String.class});
        infoFactory.addInterface(SystemLog.class);
        infoFactory.setConstructor(new String[]{"configFileName", "refreshPeriodSeconds", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class URLMonitorTask
    extends TimerTask {
        private URLMonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long lastModified;
                URLMonitorTask uRLMonitorTask = this;
                synchronized (uRLMonitorTask) {
                    if (!Log4jService.this.running) {
                        return;
                    }
                    File file = Log4jService.this.resolveConfigurationFile();
                    if (file == null) {
                        return;
                    }
                    lastModified = file.lastModified();
                }
                if (Log4jService.this.lastChanged < lastModified) {
                    Log4jService.this.lastChanged = lastModified;
                    Log4jService.this.reconfigure();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

