/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.cli.daemon.DaemonCLParser;
import org.apache.geronimo.common.GeronimoEnvironment;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DebugLoggingLifecycleMonitor;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.Main;
import org.apache.geronimo.system.main.LongStartupMonitor;
import org.apache.geronimo.system.main.ServerStatus;
import org.apache.geronimo.system.main.SilentStartupMonitor;
import org.apache.geronimo.system.main.SimpleProgressBarStartupMonitor;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDaemon
implements Main {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedDaemon.class);
    protected final Kernel kernel;
    private StartupMonitor monitor;
    private LifecycleMonitor lifecycleMonitor;
    private List<Artifact> configs = new ArrayList<Artifact>();
    static String KEYSTORE_TRUSTSTORE_PASSWORD_FILE = "org.apache.geronimo.keyStoreTrustStorePasswordFile";
    static String DEFAULT_TRUSTSTORE_KEYSTORE_LOCATION = "/var/security/keystores/geronimo-default";
    static String GERONIMO_HOME = "org.apache.geronimo.home.dir";
    static String DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE = System.getProperty(GERONIMO_HOME) + "/var/config/config-substitutions.properties";
    public static final GBeanInfo GBEAN_INFO;

    public EmbeddedDaemon(Kernel kernel) {
        this.kernel = kernel;
    }

    public int execute(Object opaque) {
        if (!(opaque instanceof DaemonCLParser)) {
            throw new IllegalArgumentException("Argument type is [" + opaque.getClass() + "]; expected [" + DaemonCLParser.class + "]");
        }
        DaemonCLParser parser = (DaemonCLParser)opaque;
        this.initializeMonitor(parser);
        this.initializeOverride(parser);
        this.initializeSecure(parser);
        long start = System.currentTimeMillis();
        System.out.println("Booting Geronimo Kernel (in Java " + System.getProperty("java.version") + ")...");
        System.out.flush();
        GeronimoEnvironment.init();
        this.monitor.systemStarting(start);
        return this.doStartup();
    }

    protected void initializeSecure(DaemonCLParser parser) {
        if (parser.isSecure()) {
            try {
                Properties props = new Properties();
                String keyStorePassword = null;
                String trustStorePassword = null;
                FileInputStream fstream = new FileInputStream(System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE));
                props.load(fstream);
                keyStorePassword = (String)((Object)EncryptionManager.decrypt((String)props.getProperty("keyStorePassword")));
                trustStorePassword = (String)((Object)EncryptionManager.decrypt((String)props.getProperty("trustStorePassword")));
                fstream.close();
                String value = System.getProperty("javax.net.ssl.keyStore", System.getProperty(GERONIMO_HOME) + DEFAULT_TRUSTSTORE_KEYSTORE_LOCATION);
                String value1 = System.getProperty("javax.net.ssl.trustStore", System.getProperty(GERONIMO_HOME) + DEFAULT_TRUSTSTORE_KEYSTORE_LOCATION);
                System.setProperty("javax.net.ssl.keyStore", value);
                System.setProperty("javax.net.ssl.trustStore", value1);
                System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void initializeOverride(DaemonCLParser parser) {
        String[] override = parser.getOverride();
        if (null != override) {
            for (String anOverride : override) {
                this.configs.add(Artifact.create((String)anOverride));
            }
        }
    }

    protected void initializeMonitor(DaemonCLParser parser) {
        this.monitor = parser.isVerboseInfo() || parser.isVerboseDebug() || parser.isVerboseTrace() || parser.isNoProgress() ? new SilentStartupMonitor() : (parser.isLongProgress() ? new LongStartupMonitor() : new SimpleProgressBarStartupMonitor());
        this.lifecycleMonitor = new DebugLoggingLifecycleMonitor(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStartup() {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null || !new File(tmpDir).exists() || !new File(tmpDir).isDirectory()) {
                System.err.println("The java.io.tmpdir system property specifies a non-existent directory: " + tmpDir);
                return 1;
            }
            File geronimoInstallDirectory = DirectoryUtils.getGeronimoInstallDirectory();
            if (geronimoInstallDirectory == null) {
                System.err.println("Could not determine geronimo installation directory");
                return 1;
            }
            int exitCode = this.initializeKernel();
            if (0 != exitCode) {
                return exitCode;
            }
            this.monitor.systemStarted(this.kernel);
            AbstractNameQuery query = new AbstractNameQuery(PersistentConfigurationList.class.getName());
            Set configLists = this.kernel.listGBeans(query);
            if (this.configs.isEmpty()) {
                for (AbstractName configListName : configLists) {
                    try {
                        this.configs.addAll((List)this.kernel.invoke(configListName, "restore"));
                    }
                    catch (IOException e) {
                        System.err.println("Unable to restore last known configurations");
                        e.printStackTrace();
                        this.shutdownKernel();
                        return 1;
                    }
                }
            }
            this.monitor.foundModules(this.configs.toArray(new Artifact[this.configs.size()]));
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
                try {
                    int unloadedConfigsCount;
                    ArrayList<Artifact> unloadedConfigs = new ArrayList<Artifact>(this.configs);
                    do {
                        unloadedConfigsCount = unloadedConfigs.size();
                        LinkedHashSet sorted = configurationManager.sort(unloadedConfigs, this.lifecycleMonitor);
                        for (Artifact configID : sorted) {
                            this.monitor.moduleLoading(configID);
                            configurationManager.loadConfiguration(configID, this.lifecycleMonitor);
                            int configModuleType = configurationManager.getConfiguration(configID).getModuleType().getValue();
                            this.monitor.moduleLoaded(configID);
                            try {
                                this.monitor.moduleStarting(configID);
                                configurationManager.startConfiguration(configID, this.lifecycleMonitor);
                                this.monitor.moduleStarted(configID);
                            }
                            catch (Exception e) {
                                if (configModuleType == ConfigurationModuleType.SERVICE.getValue()) continue;
                                log.warn("Failed to start module " + configID + "; Cause by " + e.getCause());
                                configurationManager.unloadConfiguration(configID);
                            }
                        }
                    } while (unloadedConfigsCount > unloadedConfigs.size());
                    if (!unloadedConfigs.isEmpty()) {
                        for (Artifact configID : unloadedConfigs) {
                            for (AbstractName configListName : configLists) {
                                this.kernel.invoke(configListName, "stopConfiguration", new Object[]{configID}, new String[]{Artifact.class.getName()});
                            }
                        }
                        log.warn("Could not start configs: " + unloadedConfigs);
                    }
                    AbstractNameQuery startedQuery = new AbstractNameQuery(ServerStatus.class.getName());
                    Set statusBeans = this.kernel.listGBeans(startedQuery);
                    for (AbstractName statusName : statusBeans) {
                        ServerStatus status = (ServerStatus)this.kernel.getGBean(statusName);
                        if (status == null) continue;
                        status.setServerStarted(true);
                    }
                }
                finally {
                    ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
                }
            }
            catch (Exception e) {
                this.monitor.serverStartFailed(e);
                this.shutdownKernel();
                return 1;
            }
            configLists = this.kernel.listGBeans(query);
            for (AbstractName configListName : configLists) {
                this.kernel.setAttribute(configListName, "kernelFullyStarted", (Object)Boolean.TRUE);
            }
            this.monitor.startupFinished();
            this.monitor = null;
            while (this.kernel.isRunning()) {
                try {
                    Kernel i$ = this.kernel;
                    synchronized (i$) {
                        this.kernel.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (Exception e) {
            if (this.monitor != null) {
                this.monitor.serverStartFailed(e);
            }
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    protected void shutdownKernel() {
        try {
            this.kernel.shutdown();
        }
        catch (Exception e1) {
            System.err.println("Exception caught during kernel shutdown");
            e1.printStackTrace();
        }
    }

    protected int initializeKernel() throws Exception {
        return 0;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EmbeddedDaemon.class, (String)"EmbeddedDaemon");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

