/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging;

import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.logging.SystemLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGILogServiceWrapper
implements SystemLog,
GBeanLifecycle {
    private SystemLog wrappedSystemLog;
    private String filter;
    private BundleContext bundleContext;
    private ServiceReference serviceReference;

    public OSGILogServiceWrapper(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamAttribute(name="filter") String filter) {
        this.filter = filter;
        this.bundleContext = bundleContext;
    }

    public String getConfigFileName() {
        return this.wrappedSystemLog.getConfigFileName();
    }

    public String[] getLogFileNames() {
        return this.wrappedSystemLog.getLogFileNames();
    }

    public SystemLog.SearchResults getMatchingItems(String logFile, Integer firstLine, Integer lastLine, String minLevel, String regex, int maxResults, boolean includeStackTraces) {
        return this.wrappedSystemLog.getMatchingItems(logFile, firstLine, lastLine, minLevel, regex, maxResults, includeStackTraces);
    }

    public int getRefreshPeriodSeconds() {
        return this.wrappedSystemLog.getRefreshPeriodSeconds();
    }

    public String getRootLoggerLevel() {
        return this.wrappedSystemLog.getRootLoggerLevel();
    }

    public void setConfigFileName(String fileName) {
        this.wrappedSystemLog.setConfigFileName(fileName);
    }

    public void setRefreshPeriodSeconds(int seconds) {
        this.wrappedSystemLog.setRefreshPeriodSeconds(seconds);
    }

    public void setRootLoggerLevel(String level) {
        this.wrappedSystemLog.setRootLoggerLevel(level);
    }

    public void doFail() {
        this.stop();
    }

    public void doStart() throws Exception {
        ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(SystemLog.class.getName(), this.filter);
        if (serviceReferences != null && serviceReferences.length > 0) {
            this.serviceReference = serviceReferences[0];
            this.wrappedSystemLog = (SystemLog)this.bundleContext.getService(this.serviceReference);
        }
    }

    public void doStop() throws Exception {
        this.stop();
    }

    private void stop() {
        if (this.serviceReference != null) {
            this.bundleContext.ungetService(this.serviceReference);
        }
    }
}

