/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.OutputStream;
import java.util.Collections;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.client.ClientCLParser;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.CommandLine;
import org.apache.geronimo.system.main.ExceptionUtil;

public class ClientCommandLine
extends CommandLine {
    public static void main(String[] args) {
        ClientCLParser parser = new ClientCLParser((OutputStream)System.out);
        try {
            parser.parse(args);
        }
        catch (CLParserException e) {
            System.err.println(e.getMessage());
            parser.displayHelp();
            System.exit(1);
        }
        ClientCommandLine clientCommandLine = new ClientCommandLine();
        int exitCode = clientCommandLine.execute(parser);
        System.exit(exitCode);
    }

    public ClientCommandLine(Artifact configuration, String[] args) throws Exception {
        this.startClient(configuration, args);
    }

    protected ClientCommandLine() {
    }

    public int execute(ClientCLParser parser) {
        String applicationClientConfiguration = parser.getApplicationClientConfiguration();
        this.log.info("Client startup begun of configuration: " + applicationClientConfiguration);
        try {
            Artifact configuration = Artifact.create((String)applicationClientConfiguration);
            return this.startClient(configuration, parser.getApplicationClientArgs());
        }
        catch (Exception e) {
            ExceptionUtil.trimStackTrace(e);
            if (e instanceof LifecycleException && e.getCause() instanceof NoSuchConfigException) {
                this.log.error("The client is not found in server: " + ((NoSuchConfigException)e.getCause()).getConfigId());
            } else {
                this.log.error("Client failed with exception: ", (Throwable)e);
            }
            return 2;
        }
    }

    protected int startClient(Artifact configuration, String[] args) throws Exception {
        Jsr77Naming naming = new Jsr77Naming();
        AbstractName baseName = naming.createRootName(configuration, configuration.toString(), "J2EEApplication");
        AbstractNameQuery baseNameQuery = new AbstractNameQuery(baseName);
        this.invokeMainGBean(Collections.singletonList(configuration), baseNameQuery, "main", args);
        return 0;
    }
}

