/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.daemon.DaemonCLParser;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.system.main.EmbeddedDaemon;
import org.osgi.framework.BundleContext;

public class Daemon
extends EmbeddedDaemon {
    private Daemon() {
        super(KernelFactory.newInstance(null).createKernel("geronimo"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int initializeKernel() throws Exception {
        ClassLoader classLoader = EmbeddedDaemon.class.getClassLoader();
        BundleContext bundleContext = null;
        try {
            this.kernel.boot();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        Runtime.getRuntime().addShutdownHook(new Thread("Geronimo shutdown thread"){

            @Override
            public void run() {
                System.out.println("");
                System.out.println("Server shutdown started");
                Daemon.this.kernel.shutdown();
                System.out.println("Server shutdown completed");
            }
        });
        InputStream in = classLoader.getResourceAsStream("META-INF/config.ser");
        try {
            ConfigurationUtil.loadBootstrapConfiguration((Kernel)this.kernel, (InputStream)in, bundleContext);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        DaemonCLParser parser = new DaemonCLParser((OutputStream)System.out);
        try {
            parser.parse(args);
        }
        catch (CLParserException e) {
            System.err.println(e.getMessage());
            parser.displayHelp();
            System.exit(1);
        }
        new Daemon().execute(parser);
    }
}

