/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.properties;

import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.properties.JvmVendor;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProperties {
    private static final Logger log = LoggerFactory.getLogger(SystemProperties.class);
    public static final GBeanInfo GBEAN_INFO;

    public SystemProperties(Properties systemProperties, Properties systemPathProperties, ServerInfo serverInfo, Properties sunSystemProperties, Properties ibmSystemProperties, Properties apacheSystemProperties) {
        if (log.isDebugEnabled()) {
            log.debug("Setting systemProperties");
        }
        this.setProperties(systemProperties, null);
        if (JvmVendor.isIBM()) {
            if (log.isDebugEnabled()) {
                log.debug("Setting ibmSystemProperties for the IBM JVM");
            }
            this.setProperties(ibmSystemProperties, null);
        } else if (JvmVendor.isApache()) {
            if (log.isDebugEnabled()) {
                log.debug("Setting apacheSystemProperties for the Apache Harmony JVM");
            }
            this.setProperties(apacheSystemProperties, null);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Setting sunSystemProperties for the Sun JVM");
            }
            this.setProperties(sunSystemProperties, null);
        }
        if (serverInfo != null) {
            if (log.isDebugEnabled()) {
                log.debug("Setting systemPathProperties");
            }
            this.setProperties(systemPathProperties, serverInfo);
        }
    }

    private void setProperties(Properties properties, ServerInfo serverInfo) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String currentPropertyValue;
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (serverInfo != null) {
                    propertyValue = serverInfo.resolvePath(propertyValue);
                }
                if ((currentPropertyValue = System.getProperty(propertyName)) == null) {
                    System.setProperty(propertyName, propertyValue);
                    log.info("Setting Property=" + propertyName + " to Value=" + propertyValue);
                    continue;
                }
                if (currentPropertyValue.equals(propertyValue)) {
                    log.warn("Existing Property=" + propertyName + " is already set to Value=" + currentPropertyValue);
                    continue;
                }
                log.error("Not updating existing Property=" + propertyName + " to Value=" + propertyValue + ".  Property is already set to " + currentPropertyValue);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(SystemProperties.class, (String)"GBean");
        infoBuilder.addAttribute("systemProperties", Properties.class, true, true);
        infoBuilder.addAttribute("systemPathProperties", Properties.class, true, true);
        infoBuilder.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoBuilder.addAttribute("sunSystemProperties", Properties.class, true, true);
        infoBuilder.addAttribute("ibmSystemProperties", Properties.class, true, true);
        infoBuilder.addAttribute("apacheSystemProperties", Properties.class, true, true);
        infoBuilder.setConstructor(new String[]{"systemProperties", "systemPathProperties", "ServerInfo", "sunSystemProperties", "ibmSystemProperties", "apacheSystemProperties"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

