/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.AppClientModule;
import org.apache.geronimo.management.EJBModule;
import org.apache.geronimo.management.J2EEManagedObject;
import org.apache.geronimo.management.J2EEModule;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.geronimo.J2EEApplication;
import org.apache.geronimo.management.geronimo.J2EEServer;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.management.geronimo.WebModule;

@GBean(j2eeType="J2EEApplication")
public class J2EEApplicationImpl
implements J2EEApplication {
    private final String objectName;
    private final String deploymentDescriptor;
    private final J2EEServer server;
    private final Collection<J2EEResource> resources;
    private final Collection<AppClientModule> appClientModules;
    private final Collection<EJBModule> ejbModules;
    private final Collection<ResourceAdapterModule> resourceAdapterModules;
    private final Collection<WebModule> webModules;

    public J2EEApplicationImpl(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamAttribute(name="deploymentDescriptor") String deploymentDescriptor, @ParamReference(name="Server", namingType="J2EEServer") J2EEServer server, @ParamReference(name="Resources", namingType="J2EEResource") Collection<J2EEResource> resources, @ParamReference(name="AppClientModules", namingType="AppClientModule") Collection<AppClientModule> appClientModules, @ParamReference(name="EJBModules", namingType="EJBModule") Collection<EJBModule> ejbModules, @ParamReference(name="ResourceAdapterModules", namingType="ResourceAdapterModule") Collection<ResourceAdapterModule> resourceAdapterModules, @ParamReference(name="WebModules", namingType="WebModule") Collection<WebModule> webModules) {
        this.objectName = objectName;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)this.objectName);
        this.verifyObjectName(myObjectName);
        this.deploymentDescriptor = deploymentDescriptor;
        this.server = server;
        this.resources = resources;
        this.appClientModules = appClientModules;
        this.ejbModules = ejbModules;
        this.resourceAdapterModules = resourceAdapterModules;
        this.webModules = webModules;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEApplication".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEApplication object name j2eeType property must be 'J2EEApplication'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("J2EEApplication object must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("J2EEApplication object name must contain a J2EEServer property", objectName);
        }
        if (keyPropertyList.size() != 3) {
            throw new InvalidObjectNameException("J2EEApplication object name can only have j2eeType, name, and J2EEServer properties", objectName);
        }
    }

    public String[] getModules() {
        return Util.getObjectNames((J2EEManagedObject[])this.getModulesInstances());
    }

    public J2EEModule[] getModulesInstances() {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (this.appClientModules != null) {
            objects.addAll(this.appClientModules);
        }
        if (this.ejbModules != null) {
            objects.addAll(this.ejbModules);
        }
        if (this.webModules != null) {
            objects.addAll(this.webModules);
        }
        if (this.resourceAdapterModules != null) {
            objects.addAll(this.resourceAdapterModules);
        }
        return objects.toArray(new J2EEModule[objects.size()]);
    }

    public J2EEResource[] getResources() {
        if (this.resources == null) {
            return new J2EEResource[0];
        }
        return this.resources.toArray(new J2EEResource[this.resources.size()]);
    }

    public AppClientModule[] getClientModules() {
        if (this.appClientModules == null) {
            return new AppClientModule[0];
        }
        return this.appClientModules.toArray(new AppClientModule[this.appClientModules.size()]);
    }

    public EJBModule[] getEJBModules() {
        if (this.ejbModules == null) {
            return new EJBModule[0];
        }
        return this.ejbModules.toArray(new EJBModule[this.ejbModules.size()]);
    }

    public ResourceAdapterModule[] getRAModules() {
        if (this.resourceAdapterModules == null) {
            return new ResourceAdapterModule[0];
        }
        return this.resourceAdapterModules.toArray(new ResourceAdapterModule[this.resourceAdapterModules.size()]);
    }

    public WebModule[] getWebModules() {
        if (this.webModules == null) {
            return new WebModule[0];
        }
        return this.webModules.toArray(new WebModule[this.webModules.size()]);
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getServer() {
        return this.server.getObjectName();
    }
}

