/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.EJB;
import org.apache.geronimo.management.EJBModule;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.openejb.GeronimoThreadContextListener;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(j2eeType="EJBModule")
public class EjbModuleImpl
implements EJBModule,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(EjbModuleImpl.class);
    private final J2EEServer server;
    private final J2EEApplication application;
    private final String deploymentDescriptor;
    private final String objectName;
    private final Map<String, EjbDeployment> ejbs = new HashMap<String, EjbDeployment>();
    private final ClassLoader classLoader;
    private final OpenEjbSystem openEjbSystem;
    private final EjbJarInfo ejbJarInfo;

    public EjbModuleImpl(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamReference(name="J2EEServer") J2EEServer server, @ParamReference(name="J2EEApplication") J2EEApplication application, @ParamAttribute(name="deploymentDescriptor") String deploymentDescriptor, @ParamReference(name="EJBCollection") Collection<? extends EjbDeployment> ejbs, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamReference(name="OpenEjbSystem") OpenEjbSystem openEjbSystem, @ParamAttribute(name="ejbJarInfo") EjbJarInfo ejbJarInfo) {
        this.objectName = objectName;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.server = server;
        this.application = application;
        this.deploymentDescriptor = deploymentDescriptor;
        ((ReferenceCollection)ejbs).addReferenceCollectionListener(new ReferenceCollectionListener(){

            public void memberAdded(ReferenceCollectionEvent event) {
                EjbDeployment ejb = (EjbDeployment)event.getMember();
                EjbModuleImpl.this.addEjb(ejb);
            }

            public void memberRemoved(ReferenceCollectionEvent event) {
                EjbDeployment ejb = (EjbDeployment)event.getMember();
                EjbModuleImpl.this.removeEjb(ejb);
            }
        });
        for (EjbDeployment ejbDeployment : ejbs) {
            this.addEjb(ejbDeployment);
        }
        this.classLoader = classLoader;
        this.openEjbSystem = openEjbSystem;
        this.ejbJarInfo = ejbJarInfo;
    }

    private void removeEjb(EjbDeployment ejb) {
        GeronimoThreadContextListener.get().removeEjb(ejb.getDeploymentId());
        this.ejbs.remove(ejb.getDeploymentId());
    }

    private void addEjb(EjbDeployment ejb) {
        this.ejbs.put(ejb.getDeploymentId(), ejb);
        GeronimoThreadContextListener.get().addEjb(ejb);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEjbs() {
        ArrayList<EjbDeployment> copy;
        if (this.ejbs == null) {
            return new String[0];
        }
        Map<String, EjbDeployment> map = this.ejbs;
        synchronized (map) {
            copy = new ArrayList<EjbDeployment>(this.ejbs.values());
        }
        String[] result = new String[copy.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((EJB)copy.get(i)).getObjectName();
        }
        return result;
    }

    public void doStart() throws Exception {
        this.openEjbSystem.createEjbJar(this.ejbJarInfo, this.classLoader);
        for (String deploymentId : this.ejbs.keySet()) {
            DeploymentInfo deploymentInfo = this.openEjbSystem.getDeploymentInfo(deploymentId);
            GeronimoThreadContextListener.get().getEjbDeployment((CoreDeploymentInfo)deploymentInfo);
        }
    }

    public void doStop() {
        try {
            this.openEjbSystem.removeEjbJar(this.ejbJarInfo, this.classLoader);
        }
        catch (NoSuchApplicationException e) {
            log.error("Module does not exist.", (Throwable)e);
        }
        catch (UndeployException e) {
            List causes = e.getCauses();
            log.error(e.getMessage() + ": Encountered " + causes.size() + " failures.");
            for (Throwable throwable : causes) {
                log.info(throwable.toString(), throwable);
            }
        }
    }

    public void doFail() {
        this.doStop();
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"EJBModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("EJBModule object name j2eeType property must be 'EJBModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("EJBModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("EJBModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("EJBModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("EJBModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }
}

